/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.generator.DataComponentGenerator;
import org.eclipse.scada.configuration.component.lib.Items;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.generator.FinishContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ItemReference;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.ScriptItem;

public abstract class AbstractDanglingGenerator
extends DataComponentGenerator {
    private final Map<MasterServer, ScriptItem> danglingScriptItemMap = new HashMap<MasterServer, ScriptItem>();

    public AbstractDanglingGenerator(DataComponent component) {
        super(component);
    }

    protected ScriptItem createScriptItem(CreationRequest<ScriptItem> req) {
        req.addMasterListener((MasterListener)new MasterListener<ScriptItem>(){

            public void setMaster(ScriptItem item, GeneratorContext.MasterContext master) {
                AbstractDanglingGenerator.this.danglingScriptItemMap.put(master.getImplementation(), item);
            }
        });
        return (ScriptItem)req.create();
    }

    @Override
    public void finish(FinishContext context) {
        super.finish(context);
        for (Map.Entry<MasterServer, ScriptItem> entry : this.danglingScriptItemMap.entrySet()) {
            MasterServer master = entry.getKey();
            ScriptItem item = entry.getValue();
            for (ItemReference input : item.getInputs()) {
                input.setItem(Items.replaceDanglingReference((GeneratorContext)this.context, (MasterServer)master, (Item)input.getItem()));
            }
            for (ItemReference command : item.getCommands()) {
                command.setItem(Items.replaceDanglingReference((GeneratorContext)this.context, (MasterServer)master, (Item)command.getItem()));
            }
        }
    }
}

