/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.generator.ComponentGenerator;
import org.eclipse.scada.configuration.component.generator.ItemCreatorImpl;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.component.lib.create.ItemSource;
import org.eclipse.scada.configuration.generator.FinishContext;
import org.eclipse.scada.configuration.generator.GenerationContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.infrastructure.MasterServer;
import org.eclipse.scada.configuration.utils.TypeVisitor;
import org.eclipse.scada.configuration.utils.TypeWalker;
import org.eclipse.scada.configuration.world.Application;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.deployment.DebianDeploymentMechanism;
import org.eclipse.scada.configuration.world.lib.Nodes;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.Exporter;

public abstract class DataComponentGenerator
extends ComponentGenerator
implements ItemSource {
    private final DataComponent component;

    public DataComponentGenerator(DataComponent component) {
        super((Component)component);
        this.component = component;
    }

    public void generate(GenerationContext context) {
        for (MasterServer master : this.component.getMasterOn()) {
            GeneratorContext.MasterContext mappedMaster = this.context.getMasterContext(master);
            if (mappedMaster == null) {
                throw new IllegalStateException(String.format("No mapped master found for: %s", master));
            }
            this.generateForMaster(context, mappedMaster);
        }
    }

    protected void generateForMaster(GenerationContext context, GeneratorContext.MasterContext master) {
        this.createItems(this.createItemCreator(master));
    }

    protected ItemCreator createItemCreator(GeneratorContext.MasterContext master) {
        return new ItemCreatorImpl(this.context, master, (Component)this.component);
    }

    public abstract void createItems(ItemCreator var1);

    @Override
    public void finish(FinishContext context) {
        super.finish(context);
        for (MasterServer master : this.component.getMasterOn()) {
            GeneratorContext.MasterContext mappedMaster = this.context.getMasterContext(master);
            if (mappedMaster == null) {
                throw new IllegalStateException(String.format("No mapped master found for: %s", master));
            }
            this.finishForMaster(context, mappedMaster);
        }
    }

    protected void finishForMaster(FinishContext context, GeneratorContext.MasterContext master) {
    }

    protected Collection<Endpoint> getEndpoints(EquinoxApplication app) {
        LinkedList<Endpoint> result = new LinkedList<Endpoint>();
        if (app == null) {
            return result;
        }
        for (Exporter exporter : app.getExporter()) {
            result.addAll((Collection<Endpoint>)exporter.getEndpoints());
        }
        return result;
    }

    protected void addDebianDependency(org.eclipse.scada.configuration.world.osgi.MasterServer master, final String dependecy) {
        try {
            new TypeWalker(DebianDeploymentMechanism.class).walk((Collection)Nodes.fromApp((Application)master).getDeployments(), (TypeVisitor)new TypeVisitor<DebianDeploymentMechanism>(){

                public void visit(DebianDeploymentMechanism item) throws Exception {
                    item.getAdditionalDependencies().add((Object)dependecy);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

