/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator.calc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.scada.configuration.component.AverageModule;
import org.eclipse.scada.configuration.component.CalculationComponent;
import org.eclipse.scada.configuration.component.CalculationModule;
import org.eclipse.scada.configuration.component.InputDefinition;
import org.eclipse.scada.configuration.component.OutputDefinition;
import org.eclipse.scada.configuration.component.OutputSpecification;
import org.eclipse.scada.configuration.component.generator.calc.CalculationComponentGenerator;
import org.eclipse.scada.configuration.component.generator.calc.Calculations;
import org.eclipse.scada.configuration.component.lib.Items;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.generator.FinishContext;
import org.eclipse.scada.configuration.generator.GenerationContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.world.osgi.Average;
import org.eclipse.scada.configuration.world.osgi.AverageItem;
import org.eclipse.scada.configuration.world.osgi.AverageReferenceType;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AverageModuleGenerator
extends CalculationComponentGenerator<AverageModule> {
    static final Logger logger = LoggerFactory.getLogger(AverageModuleGenerator.class);
    private final Map<MasterServer, Average> danglingMap = new HashMap<MasterServer, Average>();
    private final Map<MasterServer, Average> map = new HashMap<MasterServer, Average>();

    public AverageModuleGenerator(CalculationComponent calculationComponent) {
        super(calculationComponent, AverageModule.class);
    }

    public CreationRequest<AverageItem> createAverageItem(ItemCreator creator, AverageReferenceType type) {
        AverageItem averageItem = OsgiFactory.eINSTANCE.createAverageItem();
        averageItem.setType(type);
        return creator.addItem((Item)averageItem);
    }

    @Override
    public void createItems(ItemCreator creator, AverageModule implementation) {
        for (OutputDefinition output : this.calculationComponent.getOutputs()) {
            OutputSpecification outputSpec = Calculations.findSpecification((CalculationModule)implementation, output);
            AverageReferenceType type = AverageReferenceType.get((String)output.getName());
            if (type == null) {
                throw new IllegalStateException(String.format("Average reference type %s is unknown. Use any of %s.", output.getName(), AverageReferenceType.values()));
            }
            CreationRequest<AverageItem> c = this.createAverageItem(creator, type);
            c.localTags((Collection)output.getLocalTag());
            c.customizationTags((Collection)output.getCustomizationTags());
            c.dataType(outputSpec.getDataType());
            c.addMasterListener((MasterListener)new MasterListener<AverageItem>(){

                public void setMaster(AverageItem item, GeneratorContext.MasterContext master) {
                    Average average = (Average)AverageModuleGenerator.this.map.get(master.getImplementation());
                    item.setSource(average);
                }
            });
            c.create();
        }
    }

    @Override
    protected void generateForMaster(GenerationContext context, GeneratorContext.MasterContext master, AverageModule implementation) {
        Average average = OsgiFactory.eINSTANCE.createAverage();
        average.setName(this.makeId());
        master.getImplementation().getAverages().add((Object)average);
        average.setSourcesRequired(implementation.getValidSourcesRequired());
        this.map.put(master.getImplementation(), average);
        this.danglingMap.put(master.getImplementation(), average);
        for (InputDefinition input : Calculations.findByName((Collection<InputDefinition>)this.calculationComponent.getInputs(), "input")) {
            average.getItems().add((Object)input.createReference());
        }
        if (average.getItems().isEmpty()) {
            throw new IllegalStateException("Average must contain more than at least one item");
        }
    }

    @Override
    public void finish(FinishContext context) {
        for (Map.Entry<MasterServer, Average> entry : this.danglingMap.entrySet()) {
            Items.replaceDanglingReferences((GeneratorContext)this.context, (MasterServer)entry.getKey(), (EList)entry.getValue().getItems());
        }
        super.finish(context);
    }
}

