/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.lib.create;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.item.CustomizationRequest;
import org.eclipse.scada.configuration.world.osgi.DataType;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ItemInformation;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;

public abstract class AbstractCreationRequest<T extends Item>
implements CreationRequest<T> {
    private List<String> localTags = Collections.emptyList();
    private Set<String> customizationTags = Collections.emptySet();
    private final ItemInformation itemInformation;
    private final List<String> hierarchy;
    private final Object component;
    private final Set<MasterListener<T>> masterListeners = new HashSet<MasterListener<T>>();
    private int globalizationLevel = 1;

    public AbstractCreationRequest(Object component, List<String> hierarchy) {
        this.component = component;
        this.hierarchy = Collections.unmodifiableList(new ArrayList<String>(hierarchy));
        this.itemInformation = OsgiFactory.eINSTANCE.createItemInformation();
        this.itemInformation.getHierarchy().addAll(this.hierarchy);
    }

    @Override
    public CreationRequest<T> localTags(String ... localTags) {
        this.localTags = localTags != null ? Arrays.asList(localTags) : Collections.emptyList();
        return this;
    }

    @Override
    public CreationRequest<T> localTags(Collection<String> localTags) {
        this.localTags = localTags != null ? new ArrayList<String>(localTags) : Collections.emptyList();
        return this;
    }

    @Override
    public CreationRequest<T> information(String description, String unit, String system) {
        this.itemInformation.setDescription(description);
        this.itemInformation.setUnit(unit);
        this.itemInformation.setSystem(system);
        return this;
    }

    @Override
    public CreationRequest<T> dataType(DataType dataType) {
        this.itemInformation.setDataType(dataType);
        return this;
    }

    @Override
    public CreationRequest<T> customizationTags(String ... tags) {
        this.customizationTags = tags != null ? new HashSet<String>(Arrays.asList(tags)) : Collections.emptySet();
        return this;
    }

    @Override
    public CreationRequest<T> customizationTags(Collection<String> tags) {
        this.customizationTags = tags != null ? new HashSet<String>(tags) : Collections.emptySet();
        return this;
    }

    @Override
    public CreationRequest<T> addCustomizationTags(String ... tags) {
        if (tags != null) {
            this.customizationTags.addAll(Arrays.asList(tags));
        }
        return this;
    }

    @Override
    public CreationRequest<T> addCustomizationTags(Collection<String> tags) {
        if (tags != null) {
            this.customizationTags.addAll(tags);
        }
        return this;
    }

    @Override
    public CreationRequest<T> request(CustomizationRequest request) {
        this.customizationTags(request.getCustomizationTags());
        this.localTags(request.getLocalTags());
        this.globalizationLevel = request.getGlobalizationLevel();
        if (request.getItem().getInformation() != null) {
            this.itemInformation.setDataType(request.getItem().getInformation().getDataType());
            this.itemInformation.setDescription(request.getItem().getInformation().getDescription());
            this.itemInformation.setSystem(request.getItem().getInformation().getSystem());
        }
        return this;
    }

    @Override
    public CreationRequest<T> incrementGlobalizationLevel() {
        ++this.globalizationLevel;
        return this;
    }

    @Override
    public int getGlobalizationLevel() {
        return this.globalizationLevel;
    }

    public CustomizationRequest buildRequest(Item item) {
        item.setInformation(this.itemInformation);
        return new CustomizationRequest(this.component, item, this.hierarchy, this.localTags, this.customizationTags, this.globalizationLevel);
    }

    @Override
    public void addMasterListener(MasterListener<T> masterListener) {
        this.masterListeners.add(masterListener);
    }

    public Set<MasterListener<T>> getMasterListeners() {
        return this.masterListeners;
    }
}

