/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.lib.create;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.lib.create.CompositeItemSource;
import org.eclipse.scada.configuration.component.lib.create.ItemSource;
import org.eclipse.scada.configuration.generator.Generator;
import org.eclipse.scada.configuration.generator.GeneratorPlugin;
import org.eclipse.scada.ui.databinding.AdapterHelper;

public final class ItemSources {
    private ItemSources() {
    }

    public static ItemSource createItemSource(Component dc) {
        ItemSource itemSource = (ItemSource)AdapterHelper.adapt((Object)dc, ItemSource.class);
        if (itemSource != null) {
            return itemSource;
        }
        Set generators = GeneratorPlugin.createGeneratorsFor((Object)dc);
        HashSet<ItemSource> sources = new HashSet<ItemSource>();
        for (Generator generator : generators) {
            ItemSource source = (ItemSource)AdapterHelper.adapt((Object)generator, ItemSource.class);
            if (source == null) continue;
            sources.add(source);
        }
        if (sources.isEmpty()) {
            return null;
        }
        return new CompositeItemSource(sources);
    }
}

