/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.Device;
import org.eclipse.scada.configuration.infrastructure.lib.DriverValidator;

public class DeviceTypeValidator<T extends AbstractFactoryDriver>
implements DriverValidator<T> {
    private final Class<?> deviceClass;

    public DeviceTypeValidator(Class<?> deviceClass) {
        this.deviceClass = deviceClass;
    }

    @Override
    public void validate(IValidationContext ctx, T driver, Collection<IStatus> result) {
        HashSet<Device> locations = new HashSet<Device>();
        HashSet<String> illegalDevices = new HashSet<String>();
        for (Device device : driver.getDevices()) {
            if (this.deviceClass.isAssignableFrom(device.getClass())) continue;
            illegalDevices.add(device.getClass().getName());
            locations.add(device);
        }
        if (!illegalDevices.isEmpty()) {
            result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, locations, (int)4, (int)3, (String)"The driver may only contain device of type {0}. The following device types are invalid: {1}", (Object[])new Object[]{this.deviceClass.getName(), illegalDevices}));
        }
    }
}

