/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.memory.manager.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.memory.Attribute;
import org.eclipse.scada.configuration.memory.TypeDefinition;
import org.eclipse.scada.configuration.memory.TypeSystem;
import org.eclipse.scada.configuration.memory.Variable;
import org.eclipse.scada.configuration.memory.manager.MemoryManagerModule;
import org.eclipse.scada.configuration.memory.manager.MemoryManagerPackage;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.OscarProcessor;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;

public class MemoryModelOscarProcessor
implements OscarProcessor {
    public void process(OscarContext ctx, EquinoxApplication application, IProgressMonitor monitor) {
        try {
            Collection modules = EcoreUtil.getObjectsByType((Collection)application.getModules(), (EClassifier)MemoryManagerPackage.Literals.MEMORY_MANAGER_MODULE);
            if (modules.isEmpty()) {
                return;
            }
            if (modules.size() > 1) {
                throw new IllegalStateException(String.format("There must only be one module instance of type: %s", MemoryManagerModule.class.getName()));
            }
            this.process(ctx, application, (MemoryManagerModule)modules.iterator().next(), monitor);
        }
        finally {
            monitor.done();
        }
    }

    private void process(OscarContext ctx, EquinoxApplication application, MemoryManagerModule manager, IProgressMonitor monitor) {
        TypeSystem ts = manager.getTypeSystem();
        if (ts == null) {
            throw new IllegalStateException("Type system must not be null");
        }
        HashSet<String> typeNames = new HashSet<String>();
        HashSet<TypeSystem> systems = new HashSet<TypeSystem>();
        this.processSystem(ctx, ts, systems, typeNames);
    }

    protected void processSystem(OscarContext ctx, TypeSystem ts, Set<TypeSystem> systems, Set<String> typeNames) {
        if (!systems.add(ts)) {
            throw new IllegalStateException(String.format("Circualar dependency at %s discovered.", ts));
        }
        for (TypeSystem subTs : ts.getIncludes()) {
            this.processSystem(ctx, subTs, systems, typeNames);
        }
        for (TypeDefinition def : ts.getTypes()) {
            this.processTypeDefinition(ctx, ts, def, typeNames);
        }
    }

    private void processTypeDefinition(OscarContext ctx, TypeSystem ts, TypeDefinition def, Set<String> typeNames) {
        HashMap<String, String> data = new HashMap<String, String>();
        String typeName = def.getName();
        if (!typeNames.add(typeName)) {
            throw new IllegalStateException(String.format("Duplicate type name '%s'", typeName));
        }
        for (Variable var : def.getVariables()) {
            data.put("variable." + var.getName(), var.getType().encode());
            for (Attribute attr : var.getAttributes()) {
                data.put(String.format("attribute.%s.%s", var.getName(), attr.getName()), attr.getType().encode());
            }
        }
        ctx.addData("org.eclipse.scada.da.server.common.memory.types", typeName, data);
    }
}

