/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.ui.project.builder;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectBuilder
extends IncrementalProjectBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ProjectBuilder.class);
    private final ValidateAction.EclipseResourcesUtil helper = new ValidateAction.EclipseResourcesUtil();

    protected Set<String> getExtensions(Map<String, String> args) {
        String str = args.get("extensions");
        if (str == null || str.isEmpty()) {
            return this.getDefaultExtensions();
        }
        return new HashSet<String>(Arrays.asList(str.split(" *, *")));
    }

    private Set<String> getDefaultExtensions() {
        return new HashSet<String>(Arrays.asList("escm", "esim", "security"));
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        try {
            logger.debug("Requested build");
            Set<String> extensions = this.getExtensions(args);
            IResourceDelta delta = null;
            if (kind != 6) {
                delta = this.getDelta(this.getProject());
            }
            if (delta == null || kind == 6) {
                if (this.isInterestingProject(this.getProject())) {
                    this.validateAll(this.getProject(), adapterFactory, extensions, monitor);
                }
            } else {
                delta.accept((IResourceDeltaVisitor)new DeltaVisitor(monitor, adapterFactory, extensions));
            }
            return null;
        }
        finally {
            adapterFactory.dispose();
        }
    }

    protected void validateAll(IProject project, final ComposedAdapterFactory adapterFactory, final Set<String> extensions, final IProgressMonitor monitor) {
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    return ProjectBuilder.this.handleResource(null, resource, adapterFactory, extensions, monitor);
                }
            });
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e.getStatus());
        }
    }

    private boolean isInterestingProject(IProject project) {
        try {
            boolean result = project.hasNature("org.eclipse.scada.configuration.ui.project.configuration");
            logger.debug("Checking project - project: {}, result: {}", (Object)project, (Object)result);
            return result;
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e.getStatus());
            return false;
        }
    }

    public static URI makeUri(IResource resource) {
        return URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
    }

    public void validateFile(IFile candidate, ComposedAdapterFactory adapterFactory, IProgressMonitor monitor) {
        logger.trace("Validate file - file: {}", (Object)candidate);
        try {
            candidate.deleteMarkers("org.eclipse.emf.ecore.diagnostic", false, 0);
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource r = rs.createResource(ProjectBuilder.makeUri((IResource)candidate));
            r.load(null);
            ProjectDiagnostician diag = new ProjectDiagnostician(adapterFactory);
            EList contents = r.getContents();
            String message = null;
            BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.ecore", 0, message, contents.toArray());
            Map context = diag.createDefaultContext();
            for (EObject content : contents) {
                diag.validate(content, (DiagnosticChain)diagnostic, context);
            }
            this.helper.createMarkers((Diagnostic)diagnostic);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e.getStatus());
        }
        catch (Exception e) {
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.configuration.ui.project", (Throwable)e));
        }
    }

    public boolean isModelFile(IFile candidate, Set<String> extensions) {
        String ext = candidate.getFileExtension();
        logger.trace("Is model file - file: {}, ext: {}, list: {}", new Object[]{candidate, ext, extensions});
        if (extensions.contains(ext)) {
            logger.debug("IsModelFile");
            return true;
        }
        return false;
    }

    public boolean handleResource(IResourceDelta delta, IResource resource, ComposedAdapterFactory adapterFactory, Set<String> extensions, IProgressMonitor monitor) {
        IFile file;
        logger.trace("Handle resource - file: {}", (Object)resource);
        if (resource instanceof IProject) {
            return this.isInterestingProject((IProject)resource);
        }
        if (resource instanceof IFolder) {
            return true;
        }
        if (resource instanceof IFile && this.isModelFile(file = (IFile)resource, extensions) && (delta == null || delta.getKind() != 2)) {
            this.validateFile(file, adapterFactory, monitor);
        }
        return false;
    }

    private class DeltaVisitor
    implements IResourceDeltaVisitor {
        private final IProgressMonitor monitor;
        private final ComposedAdapterFactory adapterFactory;
        private final Set<String> extensions;

        public DeltaVisitor(IProgressMonitor monitor, ComposedAdapterFactory adapterFactory, Set<String> extensions) {
            this.monitor = monitor;
            this.adapterFactory = adapterFactory;
            this.extensions = extensions;
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            return ProjectBuilder.this.handleResource(delta, resource, this.adapterFactory, this.extensions, this.monitor);
        }
    }

    private final class ProjectDiagnostician
    extends Diagnostician {
        private final ComposedAdapterFactory adapterFactory;

        public ProjectDiagnostician(ComposedAdapterFactory adapterFactory) {
            this.adapterFactory = adapterFactory;
        }

        public String getObjectLabel(EObject eObject) {
            if (eObject.eIsProxy()) {
                return super.getObjectLabel(eObject);
            }
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
            logger.debug("Label provider: {} - for {}", (Object)itemLabelProvider, (Object)eObject);
            if (itemLabelProvider != null) {
                return itemLabelProvider.getText((Object)eObject);
            }
            return super.getObjectLabel(eObject);
        }
    }
}

