/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.ui.project.create;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.scada.configuration.recipe.CaptureOutput;
import org.eclipse.scada.configuration.recipe.Definition;
import org.eclipse.scada.configuration.recipe.Execute;
import org.eclipse.scada.configuration.recipe.MapInput;
import org.eclipse.scada.configuration.recipe.RecipeFactory;
import org.eclipse.scada.configuration.recipe.StringInputValue;
import org.eclipse.scada.configuration.recipe.Task;
import org.eclipse.scada.configuration.utils.LoadModel;
import org.eclipse.scada.configuration.utils.ModelLoader;
import org.eclipse.scada.configuration.utils.StoreModel;
import org.eclipse.scada.configuration.world.lib.deployment.NodeMappingHandler;
import org.osgi.framework.FrameworkUtil;

public class RecipeBuilder {
    public static Definition createDefaultRecipe() throws IOException {
        return RecipeBuilder.createRecipe(false);
    }

    public static Definition createIntegrationRecipe() throws IOException {
        return RecipeBuilder.createRecipe(true);
    }

    protected static Definition createRecipe(boolean nodeMappings) throws IOException {
        Definition recipe = RecipeFactory.eINSTANCE.createDefinition();
        recipe.getImport().add((Object)((Definition)new ModelLoader(Definition.class).load(URI.createURI((String)"platform:/plugin/org.eclipse.scada.configuration.generator.component/default.recipe"))));
        Task loadTask = RecipeBuilder.createTask(recipe, 0, "Load Models");
        Execute exec = RecipeBuilder.addExecute(loadTask, LoadModel.class, "load");
        RecipeBuilder.createStringInputValue(exec, "uri", "world.escm");
        RecipeBuilder.createOutputCapture(exec, "model", "componentModel");
        if (nodeMappings) {
            exec = RecipeBuilder.addExecute(loadTask, LoadModel.class, "load");
            RecipeBuilder.createStringInputValue(exec, "uri", "nodeMappings.esdi");
            RecipeBuilder.createOutputCapture(exec, "model", "nodeMappings");
        }
        if (nodeMappings) {
            Task mappings = RecipeBuilder.createTask(recipe, 550000, "Node Mappings");
            RecipeBuilder.addExecute(mappings, NodeMappingHandler.class, "execute");
        }
        Task storeTask = RecipeBuilder.createTask(recipe, Integer.MAX_VALUE, "Store Models");
        Execute exec1 = RecipeBuilder.addExecute(storeTask, StoreModel.class, "store");
        RecipeBuilder.createStringInputValue(exec1, "uri", "result.eswm");
        RecipeBuilder.createMapInput(exec1, "worldModel", "model");
        Execute exec2 = RecipeBuilder.addExecute(storeTask, StoreModel.class, "store");
        RecipeBuilder.createStringInputValue(exec2, "uri", "result.globalize");
        RecipeBuilder.createMapInput(exec2, "globalizationModel", "model");
        return recipe;
    }

    private static void createOutputCapture(Execute exec, String localName, String contextName) {
        CaptureOutput out = RecipeFactory.eINSTANCE.createCaptureOutput();
        out.setLocalName(localName);
        out.setContextName(contextName);
        exec.getOutput().add((Object)out);
    }

    private static Task createTask(Definition recipe, int order, String name) {
        Task task = RecipeFactory.eINSTANCE.createTask();
        task.setOrder(order);
        recipe.getTask().add((Object)task);
        task.setName(name);
        return task;
    }

    private static Execute addExecute(Task task, Class<?> clazz, String methodName) {
        Execute exec = RecipeFactory.eINSTANCE.createExecute();
        exec.setName(String.format("bundle-class://%s/%s#%s", FrameworkUtil.getBundle(clazz).getSymbolicName(), clazz.getName(), methodName));
        task.getExecute().add((Object)exec);
        return exec;
    }

    private static void createStringInputValue(Execute exec, String name, String value) {
        StringInputValue iv = RecipeFactory.eINSTANCE.createStringInputValue();
        iv.setName(name);
        iv.setValue(value);
        exec.getInputValue().add((Object)iv);
    }

    private static void createMapInput(Execute exec, String contextName, String localName) {
        MapInput map = RecipeFactory.eINSTANCE.createMapInput();
        map.setContextName(contextName);
        map.setLocalName(localName);
        exec.getMapInput().add((Object)map);
    }
}

