/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.ui.project.template;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.ui.templates.PluginReference;
import org.eclipse.scada.configuration.ui.project.template.BaseTemplate;
import org.eclipse.scada.ui.utils.status.StatusHelper;

public class ConnectionContextTemplate
extends BaseTemplate {
    private static final String OPT_HOSTNAME = "hostname";
    private final Map<String, Integer> interfaceMap = new HashMap<String, Integer>();
    private final Set<String> privileges = new HashSet<String>();

    public ConnectionContextTemplate() {
        this.interfaceMap.put("da", 2101);
        this.interfaceMap.put("ae", 2201);
        this.interfaceMap.put("hd", 2302);
        this.privileges.addAll(Arrays.asList("operator", "admin", "developer"));
        this.setPageCount(1);
        this.createOptions();
    }

    private void createOptions() {
        this.addOption(OPT_HOSTNAME, "Hostname", "demo.openscada.org", 0);
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, "org.eclipse.scada.configuration.doc.user.template_connection");
        page.setTitle("Connection");
        page.setDescription("Connection options");
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    public String getUsedExtensionPoint() {
        return "org.eclipse.scada.core.ui.connection.login.context";
    }

    public String[] getNewFiles() {
        return new String[0];
    }

    public String getSectionId() {
        return "connections";
    }

    @Override
    protected void fillDependencies(Collection<IPluginReference> dependencies, String schemaVersion) {
        dependencies.add((IPluginReference)new PluginReference("org.eclipse.scada.core.ui.connection.login", "0.1.0", 0));
        dependencies.add((IPluginReference)new PluginReference("org.eclipse.scada.ae.ui.connection.creator.ngp", "0.1.0", 0));
        dependencies.add((IPluginReference)new PluginReference("org.eclipse.scada.da.ui.connection.creator.ngp", "0.1.0", 0));
        dependencies.add((IPluginReference)new PluginReference("org.eclipse.scada.hd.ui.connection.creator.ngp", "0.1.0", 0));
        dependencies.add((IPluginReference)new PluginReference("org.eclipse.scada.ca.ui.connection.creator.ngp", "0.1.0", 0));
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        IPluginModelFactory factory = this.model.getPluginFactory();
        this.createConnections(factory);
    }

    protected void createConnections(IPluginModelFactory factory) throws CoreException {
        IPluginExtension ext = factory.createExtension();
        this.model.getPluginBase().add(ext);
        ext.setPoint("org.eclipse.scada.core.ui.connection.login.context");
        IPluginElement context = ConnectionContextTemplate.addElement(factory, ext, "context", this.makeId(this.getHostname()));
        context.setAttribute("label", this.getContextLabel());
        IPluginElement fac = ConnectionContextTemplate.addElement(factory, context, "factory", null);
        fac.setAttribute("class", "org.eclipse.scada.core.ui.connection.login.factory.ConnectionLoginFactory");
        this.createConnection(factory, context, "da", "NORMAL");
        this.createConnection(factory, context, "ae", "NORMAL");
        this.createConnection(factory, context, "hd", "OPTIONAL");
    }

    private void createConnection(IPluginModelFactory factory, IPluginElement context, String tag, String type) throws CoreException {
        IPluginElement con = ConnectionContextTemplate.addElement(factory, context, "connection", null);
        con.setAttribute("authUseCallbacks", "true");
        con.setAttribute("autoReconnectDelay", "10000");
        con.setAttribute("mode", type);
        try {
            con.setAttribute("uri", this.makeUri(tag));
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException(StatusHelper.convertStatus((String)"org.eclipse.scada.configuration.ui.project", (Throwable)e));
        }
        IPluginElement reg = ConnectionContextTemplate.addElement(factory, con, "registration", null);
        reg.setAttribute("servicePid", this.makeConnectionId(tag));
    }

    private String makeUri(String tag) throws UnsupportedEncodingException {
        String suffix;
        if ("da".equals(tag)) {
            StringBuilder sb = new StringBuilder("?");
            int i = 0;
            for (String priv : this.privileges) {
                if (i > 0) {
                    sb.append("&");
                }
                sb.append(String.format("session.privilege.%s=true", URLEncoder.encode(priv, "UTF-8")));
                ++i;
            }
            suffix = sb.toString();
        } else {
            suffix = "";
        }
        return String.format("%s:ngp://%s:%d%s", tag, this.getHostname(), this.interfaceMap.get(tag), suffix);
    }

    private String getHostname() {
        return this.getStringOption(OPT_HOSTNAME);
    }

    private String getContextLabel() {
        return String.format("Sample Context (%s)", this.getHostname());
    }
}

