/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.ui.project.template;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.ui.templates.PluginReference;
import org.eclipse.scada.configuration.ui.project.template.BaseTemplate;
import org.eclipse.scada.configuration.ui.project.template.Messages;

public class DetailViewTemplate
extends BaseTemplate {
    private static final String OPT_NAME = "name";
    private String id;
    private String name;

    public DetailViewTemplate() {
        this.setPageCount(1);
        this.createOptions("detailView");
    }

    public DetailViewTemplate(String id, String name) {
        this.id = id;
        this.name = name;
        this.setPageCount(1);
        this.createOptions(name);
        this.setOptionEnabled(OPT_NAME, false);
    }

    private void createOptions(String name) {
        this.addOption(OPT_NAME, Messages.DetailViewTemplate_Option_Name_Label, name, 0);
    }

    public void addPages(Wizard wizard) {
        if (this.id == null) {
            WizardPage page = this.createPage(0, "org.eclipse.scada.configuration.doc.user.template_detail_view");
            page.setTitle(Messages.DetailViewTemplate_Page_Title);
            page.setDescription(Messages.DetailViewTemplate_Page_Description);
            wizard.addPage((IWizardPage)page);
            this.markPagesAdded();
        }
    }

    public String getUsedExtensionPoint() {
        return "org.eclipse.scada.vi.details.detailView";
    }

    public String[] getNewFiles() {
        return new String[]{"resources/"};
    }

    public String getSectionId() {
        return "detailView";
    }

    @Override
    protected void fillDependencies(Collection<IPluginReference> dependencies, String schemaVersion) {
        dependencies.add((IPluginReference)new PluginReference("org.eclipse.scada.vi.details", "0.1.0", 0));
        dependencies.add((IPluginReference)new PluginReference("org.eclipse.scada.vi.details.swt", "0.1.0", 0));
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        String name = this.name != null ? this.name : this.getName();
        IPluginModelFactory factory = this.model.getPluginFactory();
        IPluginExtension ext = this.createExtension("org.eclipse.scada.vi.details.detailView", true);
        if (!ext.isInTheModel()) {
            this.model.getPluginBase().add(ext);
        }
        IPluginElement view = DetailViewTemplate.addElement(factory, ext, "detailView", this.makeId(name));
        IPluginElement viewClass = DetailViewTemplate.addElement(factory, view, "class", null);
        viewClass.setAttribute("class", "org.eclipse.scada.vi.details.swt.impl.DetailViewImpl");
        DetailViewTemplate.addParameter(factory, viewClass, "uri", String.format("platform:/plugin/%s/%s", this.model.getPluginBase().getId(), this.makeViewFileName(name)));
    }

    @Override
    protected String makeId(String name) {
        if (this.id != null) {
            return this.id;
        }
        return super.makeId(name);
    }

    protected String makeViewFileName(String name) {
        return String.format("resources/details/%s.detailview", name);
    }

    private String getName() {
        return this.getStringOption(OPT_NAME);
    }
}

