/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.ui.project.wizard;

import java.util.Arrays;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.scada.configuration.ui.project.create.CreateProjectOperation;
import org.eclipse.scada.configuration.ui.project.create.ProjectInformation;
import org.eclipse.scada.configuration.ui.project.wizard.NewProjectPage;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.statushandlers.StatusManager;

public class NewProjectWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private NewProjectPage newProjectPage;

    public NewProjectWizard() {
        this.setWindowTitle("New configuration project");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        super.addPages();
        this.newProjectPage = new NewProjectPage("newProjectPage", this.selection);
        this.addPage((IWizardPage)this.newProjectPage);
    }

    public boolean performFinish() {
        ProjectInformation info = new ProjectInformation();
        if (!this.newProjectPage.useDefaults()) {
            info.setProjectLocation(this.newProjectPage.getLocationPath());
        }
        info.setProject(this.newProjectPage.getProjectHandle());
        info.addNode("node1", Arrays.asList("REGION1", "SITE1"));
        info.addNode("node2", Arrays.asList("REGION1", "SITE2"));
        info.setGlobalize(true);
        CreateProjectOperation operation = new CreateProjectOperation(info);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.configuration.ui.project", (Throwable)e));
        }
        return true;
    }
}

