/*******************************************************************************
 * Copyright (c) 2013 IBH SYSTEMS GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBH SYSTEMS GmbH - initial API and implementation
 *******************************************************************************/

package org.eclipse.scada.configuration.validation;

import org.eclipse.emf.ecore.EValidator;
import org.eclipse.scada.configuration.component.ComponentPackage;
import org.eclipse.scada.configuration.infrastructure.InfrastructurePackage;
import org.eclipse.ui.IStartup;

/**
 * Installs an EMF <code>EValidator</code> on the Library package when we
 * start up. This validator adapts EMF's <code>EValidator</code> API to the
 * EMF Model Validation Service API.
 */
public class Startup implements IStartup
{

    /**
     * Initializes me.
     */
    public Startup ()
    {
        super ();
    }

    /**
     * Install the validator.
     */
    @Override
    public void earlyStartup ()
    {
        EValidator.Registry.INSTANCE.put ( ComponentPackage.eINSTANCE, new EValidatorAdapter () );
        EValidator.Registry.INSTANCE.put ( InfrastructurePackage.eINSTANCE, new EValidatorAdapter () );
    }
}
