/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.validation.component;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.GlobalizeComponent;
import org.eclipse.scada.configuration.infrastructure.MasterImport;

public class GlobalizationValidation
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        if (!(ctx.getTarget() instanceof GlobalizeComponent)) {
            return ctx.createSuccessStatus();
        }
        GlobalizeComponent glob = (GlobalizeComponent)ctx.getTarget();
        LinkedList<IStatus> result = new LinkedList<IStatus>();
        this.validate(glob, ctx, result);
        if (result.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        if (result.size() == 1) {
            return (IStatus)result.get(0);
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, result);
    }

    private void validate(GlobalizeComponent glob, IValidationContext ctx, List<IStatus> result) {
        MasterImport sourceMaster;
        if (glob.getComponents().contains((Object)glob)) {
            result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, Arrays.asList(glob), (int)4, (int)1, (String)"The globalization component import itself. This is not allowed.", (Object[])new Object[0]));
        }
        if ((sourceMaster = glob.getSourceMaster()) != null) {
            LinkedList<DataComponent> illegal = new LinkedList<DataComponent>();
            for (DataComponent dc : glob.getComponents()) {
                if (dc.getMasterOn().contains((Object)sourceMaster.getImportedMaster())) continue;
                illegal.add(dc);
            }
            if (!illegal.isEmpty()) {
                result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, illegal, (int)4, (int)1, (String)"The globalization component imports components through MasterImport {0} but some referenced components do not run there.", (Object[])new Object[]{sourceMaster}));
            }
        }
    }
}

