/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.scada.configuration.world.Application;
import org.eclipse.scada.configuration.world.ApplicationNode;
import org.eclipse.scada.configuration.world.Node;
import org.eclipse.scada.configuration.world.deployment.MsiDeploymentMechanism;
import org.eclipse.scada.configuration.world.deployment.P2Platform;
import org.eclipse.scada.configuration.world.lib.Nodes;
import org.eclipse.scada.configuration.world.lib.deployment.CommonHandler;
import org.eclipse.scada.configuration.world.lib.deployment.wix.AntWixBuilder;
import org.eclipse.scada.configuration.world.lib.deployment.wix.MsiPlatform;
import org.eclipse.scada.configuration.world.lib.deployment.wix.WixDeploymentSetupBuilder;
import org.eclipse.scada.configuration.world.lib.oscar.P2ProfileProcessor;
import org.eclipse.scada.configuration.world.lib.utils.Helper;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;

public class MsiHandler
extends CommonHandler {
    private final MsiDeploymentMechanism deployment;

    public MsiHandler(ApplicationNode applicationNode, MsiDeploymentMechanism deployment) {
        super(applicationNode);
        this.deployment = deployment;
    }

    @Override
    protected void handleProcess(IFolder nodeDir, IProgressMonitor monitor, Map<String, String> properties) throws Exception {
        boolean enableSubst;
        File packageFolder = this.getPackageFolder(nodeDir);
        String packageName = this.getPackageName();
        MsiPlatform platform = this.convertPlatform();
        File licenseFile = this.deployment.getLicenseFile() != null && !this.deployment.getLicenseFile().isEmpty() ? nodeDir.getProject().getFile((IPath)new Path(this.deployment.getLicenseFile())).getLocation().toFile() : null;
        File stage = new File(packageFolder, "staging");
        stage.mkdirs();
        this.createStage(nodeDir.getLocation().toFile(), stage, monitor);
        boolean bl = enableSubst = !Boolean.parseBoolean(properties.get("msi.disableSubst"));
        if (enableSubst) {
            Helper.createFile(new File(packageFolder, "README.subst.txt"), MsiHandler.class.getResourceAsStream("templates/msi/README.subst.txt"), monitor, false);
        }
        Helper.createFile(new File(packageFolder, "README.ant.txt"), MsiHandler.class.getResourceAsStream("templates/msi/README.ant.txt"), monitor, false);
        WixDeploymentSetupBuilder wixBuilder = new WixDeploymentSetupBuilder();
        wixBuilder.setLicenseFile(licenseFile);
        wixBuilder.setUseFirewall(this.deployment.isEnableFirewall());
        wixBuilder.setUseUserInterface(this.deployment.isEnableUserInterface());
        wixBuilder.setPlatform(platform);
        wixBuilder.setName(String.format("Deployment package for node %s", Nodes.makeName((Node)this.applicationNode)));
        wixBuilder.setVersion(this.deployment.getVersion());
        wixBuilder.setManufacturer(this.deployment.getManufacturer());
        wixBuilder.setUpgradeCode(this.deployment.getUpgradeCode());
        for (String driverName : this.makeDriverList()) {
            this.createDriver(wixBuilder, nodeDir.getLocation().toFile(), driverName);
        }
        HashSet<String> wixExt = new HashSet<String>();
        if (this.deployment.isEnableFirewall()) {
            wixExt.add("WixFirewallExtension");
        }
        if (this.deployment.isEnableUserInterface()) {
            wixExt.add("WixUIExtension");
        }
        AntWixBuilder antBuilder = new AntWixBuilder(String.format("%s_%s.msi", packageName, this.deployment.getVersion()), platform, this.findPlatform(), wixExt, enableSubst);
        this.createApplications(nodeDir.getLocation().toFile(), antBuilder, wixBuilder);
        wixBuilder.write(packageFolder);
        antBuilder.write(packageFolder);
    }

    private P2Platform findPlatform() {
        if (this.deployment.getLocalPlatform() != null) {
            return this.deployment.getLocalPlatform();
        }
        if (this.deployment.getSharedPlatform() != null) {
            return this.deployment.getSharedPlatform();
        }
        throw new IllegalStateException("MSI deployment has not P2 target platform assigned. Use either local or shared platform.");
    }

    private MsiPlatform convertPlatform() {
        switch (this.deployment.getArchitecture()) {
            case I386: {
                return MsiPlatform.WIN32;
            }
            case AMD64: {
                return MsiPlatform.WIN64;
            }
        }
        throw new IllegalStateException(String.format("Architecture %s is not supported.", this.deployment.getArchitecture()));
    }

    private void createApplications(File baseDir, AntWixBuilder antBuilder, WixDeploymentSetupBuilder wixBuilder) {
        for (Application app : this.applicationNode.getApplications()) {
            if (!(app instanceof EquinoxApplication)) continue;
            EquinoxApplication eapp = (EquinoxApplication)app;
            Profile profile = P2ProfileProcessor.makeProfile(eapp);
            antBuilder.addApplication(new AntWixBuilder.Application(app.getName(), profile));
            File configurationBaseDir = new File(baseDir, eapp.getName());
            wixBuilder.addApplication(new WixDeploymentSetupBuilder.EquinoxAppService(app.getName(), profile, configurationBaseDir));
        }
    }

    private void createDriver(WixDeploymentSetupBuilder wixBuilder, File nodeDir, String driverName) throws Exception {
        File sourceDir = new File(nodeDir, driverName);
        Properties p = new Properties();
        File properties = new File(sourceDir, "application.properties");
        if (properties.isFile()) {
            p.load(new FileInputStream(properties));
        }
        File exporter = new File(sourceDir, "exporter.xml");
        wixBuilder.addCommonDriver(new WixDeploymentSetupBuilder.CommonDriverService(driverName, exporter, p));
    }

    private void createStage(File nodeDir, File stage, IProgressMonitor monitor) throws IOException {
    }

    @Override
    protected String getBaseFolderName() {
        return "msi-packages";
    }
}

