/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.configuration.world.ApplicationNode;
import org.eclipse.scada.configuration.world.deployment.ChangeEntry;
import org.eclipse.scada.configuration.world.deployment.RedhatDeploymentMechanism;
import org.eclipse.scada.configuration.world.lib.deployment.ChangeEntryComparator;
import org.eclipse.scada.configuration.world.lib.deployment.CommonPackageHandler;
import org.eclipse.scada.configuration.world.lib.utils.Helper;
import org.eclipse.scada.configuration.world.lib.utils.ProcessRunner;
import org.eclipse.scada.utils.str.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedhatHandler
extends CommonPackageHandler {
    private static final Logger logger = LoggerFactory.getLogger(RedhatHandler.class);
    private final RedhatDeploymentMechanism deploy;
    private static Pattern ALT_PATTERN = Pattern.compile("\\@\\@(.*?)\\@\\@");

    public RedhatHandler(ApplicationNode applicationNode, RedhatDeploymentMechanism deploy) {
        super(applicationNode);
        this.deploy = deploy;
    }

    @Override
    protected String getBaseFolderName() {
        return "rpm-packages";
    }

    @Override
    protected void handleProcess(IFolder nodeDir, IProgressMonitor monitor, Map<String, String> properties) throws Exception {
        File packageFolder = this.getPackageFolder(nodeDir);
        String packageName = this.getPackageName();
        File buildRoot = packageFolder.getParentFile();
        File specsDir = new File(buildRoot, "SPECS");
        specsDir.mkdirs();
        File sourcesDir = new File(buildRoot, "SOURCES");
        sourcesDir.mkdirs();
        String version = this.makeVersion((List<ChangeEntry>)this.deploy.getChanges());
        String qualifier = this.makeRelease();
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("packageName", packageName);
        replacements.put("authorName", this.deploy.getMaintainer().getName());
        replacements.put("authorEmail", this.deploy.getMaintainer().getEmail());
        replacements.put("nodeName", this.applicationNode.getName() == null ? this.applicationNode.getHostName() : this.applicationNode.getName());
        replacements.put("version", version);
        replacements.put("qualifier", qualifier);
        replacements.put("changeLog", this.makeChangeLog((List<ChangeEntry>)this.deploy.getChanges()));
        replacements.put("files", this.makeFiles());
        replacements.put("depends", this.makeDependencies());
        replacements.put("preun", this.makeStop());
        replacements.put("post", this.makePost());
        replacements.put("license", this.deploy.getLicense());
        File specFile = new File(specsDir, String.valueOf(packageName) + ".spec");
        Helper.createFile(specFile, RedhatHandler.class.getResourceAsStream("templates/rpm/template.spec"), replacements, monitor);
        Helper.createFile(new File(packageFolder, "Makefile"), RedhatHandler.class.getResourceAsStream("templates/rpm/Makefile"), replacements, monitor);
        this.createDrivers(nodeDir, monitor, packageFolder, replacements);
        this.createEquinox(nodeDir.getLocation().toFile(), packageFolder, replacements, monitor);
        monitor.setTaskName("Running tar");
        File sourceFile = new File(sourcesDir, String.valueOf(packageName) + "_" + version + "." + qualifier + ".tar.gz");
        ProcessBuilder processBuilder = new ProcessBuilder("tar", "czf", sourceFile.toString(), packageName);
        processBuilder.directory(packageFolder.getParentFile());
        try {
            int rc = new ProcessRunner(processBuilder).run();
            logger.info("rc = {}", (Object)rc);
        }
        catch (Exception e) {
            logger.warn("Failed to generate tar package", (Throwable)e);
        }
        if (!Boolean.parseBoolean(properties.get("skipRunDeployment"))) {
            monitor.setTaskName("Running rpmbuild");
            ProcessBuilder processBuilder2 = new ProcessBuilder("rpmbuild", "--define", "_topdir " + buildRoot.toString(), "-bb", specFile.toString());
            processBuilder2.directory(packageFolder);
            try {
                int rc = new ProcessRunner(processBuilder2).run();
                logger.info("rc = {}", (Object)rc);
            }
            catch (Exception e) {
                logger.warn("Failed to generate rpm package", (Throwable)e);
            }
            nodeDir.refreshLocal(2, monitor);
        }
    }

    private String makeStop() {
        StringBuilder sb = new StringBuilder();
        for (String driver : this.makeDriverList()) {
            sb.append("test \"$1\" -eq \"0\" && /etc/init.d/scada.driver." + driver + " stop || true");
            sb.append("\n");
        }
        for (String driver : this.makeEquinoxList()) {
            sb.append("test \"$1\" -eq \"0\" && /etc/init.d/scada.app." + driver + " stop || true");
            sb.append("\n");
        }
        return sb.toString();
    }

    private String makePost() {
        StringBuilder sb = new StringBuilder();
        for (String driver : this.makeDriverList()) {
            sb.append("/etc/init.d/scada.driver." + driver + " condrestart || true");
            sb.append("\n");
        }
        for (String driver : this.makeEquinoxList()) {
            sb.append("/etc/init.d/scada.app." + driver + " condrestart || true");
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    protected void processDriver(IProgressMonitor monitor, File packageFolder, Map<String, String> replacements, String driverName, File sourceDir, File driverDir) throws IOException, Exception {
        super.processDriver(monitor, packageFolder, replacements, driverName, sourceDir, driverDir);
        File initFile = new File(packageFolder, "src/etc/init.d/scada.driver." + driverName);
        Helper.createFile(initFile, RedhatHandler.class.getResourceAsStream("templates/rpm/driver.service.sh"), replacements, monitor);
        initFile.setExecutable(true);
    }

    @Override
    protected void processEquinox(File sourceBase, File packageFolder, Map<String, String> replacements, IProgressMonitor monitor, String name) throws IOException, Exception, FileNotFoundException {
        super.processEquinox(sourceBase, packageFolder, replacements, monitor, name);
        File file = new File(packageFolder, "src/etc/init.d/scada.app." + name);
        Helper.createFile(file, RedhatHandler.class.getResourceAsStream("templates/rpm/p2.service.sh"), replacements, monitor);
        file.setExecutable(true);
        file = new File(packageFolder, "src/usr/bin/scada.app." + name + ".launcher");
        Helper.createFile(file, RedhatHandler.class.getResourceAsStream("templates/rpm/p2.launcher.sh"), replacements, monitor, ALT_PATTERN);
        file.setExecutable(true);
    }

    private String makeDependencies() {
        HashSet<String> result = new HashSet<String>();
        result.add("Requires: org.eclipse.scada");
        if (this.needP2()) {
            result.add("Requires: org.eclipse.scada.p2");
        }
        result.add("Requires: org.eclipse.scada.deploy.p2-incubation");
        for (String dep : this.deploy.getAdditionalDependencies()) {
            result.add("Requires: " + dep);
        }
        return StringHelper.join(result, (String)"\n");
    }

    private String makeFiles() {
        StringBuilder sb = new StringBuilder();
        for (String driver : this.makeDriverList()) {
            sb.append("%dir %_sysconfdir/eclipsescada/drivers/" + driver);
            sb.append('\n');
            sb.append("%attr(640,root,eclipsescada) %_sysconfdir/eclipsescada/drivers/" + driver + "/*");
            sb.append('\n');
            sb.append("%attr(755,root,root) /etc/init.d/scada.driver." + driver);
            sb.append('\n');
        }
        for (String app : this.makeEquinoxList()) {
            sb.append("%attr(755,root,root) /etc/init.d/scada.app." + app);
            sb.append('\n');
            sb.append("%attr(755,root,root) %_bindir/scada.create." + app);
            sb.append('\n');
            sb.append("%attr(755,root,root) %_bindir/scada.app." + app + ".launcher");
            sb.append('\n');
            sb.append("%attr(640,root,eclipsescada) /usr/share/eclipsescada/ca.bootstrap/bootstrap." + app + ".json");
            sb.append('\n');
            sb.append("%attr(640,root,eclipsescada) /usr/share/eclipsescada/profiles/" + app + ".profile.xml");
            sb.append('\n');
            sb.append("%dir /usr/share/eclipsescada/profiles/" + app);
            sb.append('\n');
            sb.append("%attr(640,root,eclipsescada) /usr/share/eclipsescada/profiles/" + app + "/*");
            sb.append('\n');
        }
        return sb.toString();
    }

    private String makeRelease() {
        return String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", new Date());
    }

    private String makeChangeLog(List<ChangeEntry> changes) {
        ArrayList<ChangeEntry> sortedChanges = new ArrayList<ChangeEntry>(changes);
        Collections.sort(sortedChanges, new ChangeEntryComparator(false));
        StringBuilder sb = new StringBuilder();
        for (ChangeEntry entry : sortedChanges) {
            Formatter f = new Formatter(sb, Locale.ENGLISH);
            f.format("* %3$ta %3$tb %3$td %3$tY %1$s <%2$s> %4$s", entry.getAuthor().getName(), entry.getAuthor().getEmail(), entry.getDate(), entry.getVersion());
            f.close();
            sb.append('\n');
            sb.append(entry.getDescription());
            sb.append('\n');
        }
        return sb.toString();
    }

    private String makeVersion(List<ChangeEntry> changes) {
        String version = null;
        Date date = null;
        for (ChangeEntry entry : changes) {
            if (date != null && !date.before(entry.getDate())) continue;
            date = entry.getDate();
            version = entry.getVersion();
        }
        return version == null ? "0.0.0" : version;
    }
}

