/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.utils;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.utils.str.StringReplacer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper {
    private static final Logger logger = LoggerFactory.getLogger(Helper.class);
    private static Pattern PATTERN = Pattern.compile("\\$\\$(.*?)\\$\\$");

    public static void createFile(File file, InputStream resource, Map<String, String> replacements, IProgressMonitor monitor) throws Exception {
        Helper.createFile(file, resource, replacements, monitor, PATTERN);
    }

    public static void createFile(File file, final InputStream resource, Map<String, String> replacements, IProgressMonitor monitor, Pattern pattern) throws Exception {
        String str = CharStreams.toString((InputSupplier)CharStreams.newReaderSupplier((InputSupplier)new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                return resource;
            }
        }, (Charset)Charset.forName("UTF-8")));
        str = StringReplacer.replace((String)str, (StringReplacer.ReplaceSource)StringReplacer.newSource(replacements), (Pattern)pattern);
        Helper.createFile(file, str, monitor);
    }

    public static void createFile(File file, InputStream resource, IProgressMonitor monitor, boolean exec) throws Exception {
        file.getParentFile().mkdirs();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                ByteStreams.copy((InputStream)resource, (OutputStream)fos);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            file.setExecutable(exec);
        }
        finally {
            resource.close();
        }
    }

    public static void createFile(File file, String data, IProgressMonitor monitor) throws Exception {
        logger.debug("Writing string data file: {}", (Object)file);
        file.getParentFile().mkdirs();
        Files.write((CharSequence)data, (File)file, (Charset)Charset.forName("UTF-8"));
    }
}

