/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.deployment;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Architecture implements Enumerator
{
    I386(0, "i386", "i386"),
    AMD64(1, "amd64", "amd64");

    public static final int I386_VALUE = 0;
    public static final int AMD64_VALUE = 1;
    private static final Architecture[] VALUES_ARRAY;
    public static final List<Architecture> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Architecture[]{I386, AMD64};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Architecture get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Architecture result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Architecture getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Architecture result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Architecture get(int value) {
        switch (value) {
            case 0: {
                return I386;
            }
            case 1: {
                return AMD64;
            }
        }
        return null;
    }

    private Architecture(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

