/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.osgi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ErrorHandling implements Enumerator
{
    IGNORE(0, "IGNORE", "IGNORE"),
    COUNT(1, "COUNT", "COUNT"),
    ERROR(2, "ERROR", "ERROR");

    public static final int IGNORE_VALUE = 0;
    public static final int COUNT_VALUE = 1;
    public static final int ERROR_VALUE = 2;
    private static final ErrorHandling[] VALUES_ARRAY;
    public static final List<ErrorHandling> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ErrorHandling[]{IGNORE, COUNT, ERROR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ErrorHandling get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ErrorHandling result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ErrorHandling getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ErrorHandling result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ErrorHandling get(int value) {
        switch (value) {
            case 0: {
                return IGNORE;
            }
            case 1: {
                return COUNT;
            }
            case 2: {
                return ERROR;
            }
        }
        return null;
    }

    private ErrorHandling(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

