/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.client.ngp;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.Callbacks;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.stats.StatisticsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenCallbacksManager {
    private static final Logger logger = LoggerFactory.getLogger(OpenCallbacksManager.class);
    private static final Object STAT_OPEN_CALLBACK_FUTURES = new Object();
    private final StatisticsImpl statistics;
    private final ScheduledExecutorService executor;
    private final Set<NotifyFuture<Callback[]>> openFutures = new HashSet<NotifyFuture<Callback[]>>();
    private final Object lock;

    public OpenCallbacksManager(Object lock, StatisticsImpl statistics, ScheduledExecutorService executor) {
        this.lock = lock;
        this.statistics = statistics;
        this.executor = executor;
        statistics.setLabel(STAT_OPEN_CALLBACK_FUTURES, "Active callbacks");
    }

    public void disconnected() {
        logger.debug("Disconnected");
        for (NotifyFuture<Callback[]> future : this.openFutures) {
            future.cancel(true);
        }
        this.openFutures.clear();
        this.statistics.setCurrentValue(STAT_OPEN_CALLBACK_FUTURES, 0.0);
    }

    public NotifyFuture<Callback[]> processCallbacks(CallbackHandler callbackHandler, Callback[] callbacks, Long timeout) {
        logger.debug("Process callbacks: {}", (Object)callbacks);
        final NotifyFuture future = Callbacks.callback((CallbackHandler)callbackHandler, (Callback[])callbacks);
        logger.debug("Future opened: {}", (Object)callbacks);
        if (timeout != null && timeout > 0L && !future.isDone()) {
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    if (!future.isCancelled()) {
                        future.cancel(true);
                    }
                }
            }, (long)timeout, TimeUnit.MILLISECONDS);
        }
        this.openFutures.add((NotifyFuture<Callback[]>)future);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                OpenCallbacksManager.this.closeFuture((NotifyFuture<Callback[]>)future);
            }
        });
        this.statistics.setCurrentValue(STAT_OPEN_CALLBACK_FUTURES, (double)this.openFutures.size());
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFuture(NotifyFuture<Callback[]> future) {
        logger.debug("Future closed: {}", future);
        Object object = this.lock;
        synchronized (object) {
            this.openFutures.remove(future);
            this.statistics.setCurrentValue(STAT_OPEN_CALLBACK_FUTURES, (double)this.openFutures.size());
        }
    }
}

