/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.common;

import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.AuthorizationImplementation;
import org.eclipse.scada.sec.AuthorizationReply;
import org.eclipse.scada.sec.AuthorizationResult;
import org.eclipse.scada.sec.auth.logon.LogonAuthorizationService;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.eclipse.scada.sec.authz.AuthorizationRule;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.concurrent.TransformResultFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorization
implements AuthorizationImplementation {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAuthorization.class);
    private final LogonAuthorizationService logonHandler = new LogonAuthorizationService();
    private final AuthorizationRule rule;

    public DefaultAuthorization(AuthenticationImplementation authenticator) {
        this.logonHandler.setAuthenticator(authenticator);
        this.rule = this.logonHandler.createRule(null);
    }

    public NotifyFuture<AuthorizationReply> authorize(final AuthorizationContext context, AuthorizationResult defaultResult) {
        logger.debug("Requesting authorization - {} ... defaulting to GRANTED", new Object[]{context.getRequest(), defaultResult});
        if ("SESSION".equals(context.getRequest().getObjectType()) && "CONNECT".equals(context.getRequest().getAction())) {
            logger.debug("Default authentication is handled here");
            return new TransformResultFuture<AuthorizationResult, AuthorizationReply>(this.rule.authorize(context)){

                protected AuthorizationReply transform(AuthorizationResult from) {
                    logger.debug("Default authentication call result: {}", (Object)from);
                    if (from == null) {
                        return AuthorizationReply.createGranted((AuthorizationContext)context);
                    }
                    return AuthorizationReply.create((AuthorizationResult)from, (AuthorizationContext)context);
                }
            };
        }
        return new InstantFuture((Object)AuthorizationReply.createGranted((AuthorizationContext)context));
    }
}

