/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.common;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.mina.core.service.IoAcceptor;
import org.eclipse.scada.core.ConnectionInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkHelper {
    private static final Logger logger = LoggerFactory.getLogger(NetworkHelper.class);

    public static Set<ConnectionInformation> getLocalInterfaces(IoAcceptor acceptor, ConnectionInformation connectionInformation) throws SocketException {
        HashSet<ConnectionInformation> result = new HashSet<ConnectionInformation>();
        for (InetSocketAddress address : NetworkHelper.getLocalAddresses(acceptor)) {
            result.add(NetworkHelper.cloneFill(address.getAddress(), connectionInformation));
        }
        return result;
    }

    public static Set<InetSocketAddress> getLocalAddresses(IoAcceptor acceptor) throws SocketException {
        HashSet<InetSocketAddress> result = new HashSet<InetSocketAddress>();
        for (SocketAddress address : acceptor.getLocalAddresses()) {
            logger.info("Bound to: {}", (Object)address);
            if (!(address instanceof InetSocketAddress)) continue;
            InetSocketAddress socketAddress = (InetSocketAddress)address;
            if (socketAddress.getAddress().isAnyLocalAddress()) {
                int port = socketAddress.getPort();
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = interfaces.nextElement();
                    for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                        result.add(new InetSocketAddress(interfaceAddress.getAddress(), port));
                    }
                }
                continue;
            }
            result.add(socketAddress);
        }
        return result;
    }

    private static ConnectionInformation cloneFill(InetAddress inetAddress, ConnectionInformation connectionInformation) {
        ConnectionInformation info = connectionInformation.clone();
        info.setTarget(inetAddress.getHostAddress());
        return info;
    }
}

