/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.common.marker;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.common.AbstractCommonHandlerImpl;
import org.eclipse.scada.da.master.common.internal.Activator;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.util.tracker.ServiceTracker;

public class MarkerHandlerImpl
extends AbstractCommonHandlerImpl {
    private Configuration configuration;
    private final EventProcessor eventProcessor;
    private final String attrActive;

    public MarkerHandlerImpl(String configurationId, EventProcessor eventProcessor, ObjectPoolTracker<MasterItem> poolTracker, int priority, ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> caTracker) {
        super(configurationId, poolTracker, priority, caTracker, "org.eclipse.scada.da.master.common.marker." + configurationId, "org.eclipse.scada.da.master.common.marker");
        this.eventProcessor = eventProcessor;
        this.attrActive = this.getPrefixed("active", Activator.getStringInterner());
    }

    @Override
    protected void processDataUpdate(Map<String, Object> context, DataItemValue.Builder builder) throws Exception {
        this.injectAttributes(context, builder);
    }

    protected void injectAttributes(Map<String, Object> context, DataItemValue.Builder builder) {
        if (this.configuration == null) {
            return;
        }
        if (this.configuration.active) {
            context.putAll(this.configuration.markers);
        }
        if (this.configuration.exportAttribute && (this.configuration.active || this.configuration.alwaysExport)) {
            builder.setAttribute(this.attrActive, Variant.valueOf((boolean)this.configuration.active));
        }
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> parameters) throws Exception {
        super.update(userInformation, parameters);
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        Configuration c = new Configuration(this.configuration, (AbstractCommonHandlerImpl)this, this.eventProcessor);
        c.setActive(userInformation, cfg.getBoolean("active", false));
        c.setExportAttribute(cfg.getBoolean("exportAttribute", false));
        c.setAlwaysExport(cfg.getBoolean("alwaysExport", false));
        HashMap<String, Object> markers = new HashMap<String, Object>();
        for (Map.Entry entry : cfg.getPrefixed("marker.").entrySet()) {
            String value = (String)entry.getValue();
            if (value == null || value.isEmpty()) {
                markers.put((String)Activator.getStringInterner().intern((Object)((String)entry.getKey())), true);
                continue;
            }
            markers.put((String)Activator.getStringInterner().intern((Object)((String)entry.getKey())), value);
        }
        c.setMarkers(markers);
        this.configuration = c;
        c.sendEvents();
        this.reprocess();
    }

    @Override
    protected void injectEventAttributes(Event.EventBuilder builder) {
        super.injectEventAttributes(builder);
        builder.attribute(Event.Fields.MONITOR_TYPE, (Object)"MARKER");
    }

    protected WriteAttributeResults handleUpdate(Map<String, Variant> attributes, OperationParameters operationParameters) throws Exception {
        Variant active;
        HashMap<String, String> data = new HashMap<String, String>();
        if (this.configuration != null && (active = attributes.get("active")) != null && !active.isNull()) {
            data.put("active", active.asBoolean() ? "true" : "false");
        }
        return this.updateConfiguration(data, attributes, false, operationParameters);
    }

    private static class Configuration
    extends AbstractCommonHandlerImpl.AbstractConfiguration {
        private boolean active;
        private boolean exportAttribute;
        private boolean alwaysExport;
        private Map<String, Object> markers;

        public Configuration(Configuration currentConfiguration, AbstractCommonHandlerImpl commonHandler, EventProcessor eventProcessor) {
            super(currentConfiguration, commonHandler, eventProcessor);
            if (currentConfiguration != null) {
                this.active = currentConfiguration.active;
                this.exportAttribute = currentConfiguration.exportAttribute;
                this.alwaysExport = currentConfiguration.alwaysExport;
                this.markers = currentConfiguration.markers;
            }
        }

        public void setActive(UserInformation userInformation, boolean active) {
            this.active = (Boolean)this.update(userInformation, this.active, active);
        }

        public void setExportAttribute(boolean exportAttribute) {
            this.exportAttribute = exportAttribute;
        }

        public void setAlwaysExport(boolean alwaysExport) {
            this.alwaysExport = alwaysExport;
        }

        public void setMarkers(Map<String, Object> markers) {
            this.markers = markers;
        }
    }
}

