/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.io;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.io.WrongSessionException;
import org.eclipse.scada.da.server.common.osgi.factory.DataItemFactory;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionDevice {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnectionDevice.class);
    protected final ScheduledExecutorService executor;
    protected final BundleContext context;
    protected final String id;
    protected final DataItemFactory itemFactory;
    private final String itemPrefix;
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private String host;
    private Short port;
    private ConnectionState state = ConnectionState.DISCONNECTED;
    private final IoHandler handler = new IoHandler(){

        public void exceptionCaught(IoSession session, Throwable error) throws Exception {
            AbstractConnectionDevice.this.handleExceptionCaught(session, error);
        }

        public void messageSent(IoSession session, Object message) throws Exception {
            AbstractConnectionDevice.this.handleMessageSent(session, message);
        }

        public void sessionCreated(IoSession session) throws Exception {
            AbstractConnectionDevice.this.handleSessionCreated(session);
        }

        public void sessionClosed(IoSession session) throws Exception {
            AbstractConnectionDevice.this.handleSessionClosed(session);
        }

        public void sessionIdle(IoSession session, IdleStatus idleStatus) throws Exception {
            AbstractConnectionDevice.this.handleSessionIdle(session, idleStatus);
        }

        public void sessionOpened(IoSession session) throws Exception {
            AbstractConnectionDevice.this.handleSessionOpened(session);
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            AbstractConnectionDevice.this.handleMessageReceived(session, message);
        }
    };
    private NioSocketConnector connector;
    private IoSession session;
    private final DataItemInputChained stateItem;
    private final DataItemInputChained connectionItem;
    private int connectTimeout;
    private String name;
    private boolean enabled;
    private final NioProcessor processor;
    private ScheduledExecutorService createdExecutor;

    public AbstractConnectionDevice(BundleContext context, String id, NioProcessor processor, ScheduledExecutorService executor, String itemPrefix) {
        this.id = id;
        this.processor = processor;
        this.context = context;
        this.itemPrefix = itemPrefix;
        this.executor = executor;
        this.itemFactory = new DataItemFactory(context, (Executor)executor, this.getItemId(null));
        this.stateItem = this.itemFactory.createInput("state", Collections.emptyMap());
        this.connectionItem = this.itemFactory.createInput("connection", Collections.emptyMap());
    }

    public AbstractConnectionDevice(BundleContext context, String id, NioProcessor processor, String threadPrefix, String itemPrefix) {
        this(context, id, processor, Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory(String.valueOf(threadPrefix) + "/" + id)), itemPrefix);
        this.createdExecutor = this.executor;
    }

    public String getItemId(String localId) {
        if (localId == null) {
            return String.valueOf(this.itemPrefix) + "." + this.id;
        }
        return String.valueOf(this.itemPrefix) + "." + this.id + "." + localId;
    }

    public String getVarItemId(String localId) {
        String name = this.name;
        if (name == null) {
            name = this.id;
        }
        return this.getItemId(localId);
    }

    protected ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            this.performDispose();
        }
    }

    protected void performDispose() {
        this.disconnect();
        this.stateItem.updateData(Variant.valueOf((Object)"DISPOSED"), null, null);
        if (this.connector != null) {
            this.connector.dispose();
            this.connector = null;
        }
        this.itemFactory.dispose();
        if (this.createdExecutor != null) {
            this.createdExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configure(Map<String, String> properties) throws Exception {
        this.host = properties.get("host");
        this.port = Short.valueOf(properties.get("port"));
        this.connectTimeout = AbstractConnectionDevice.getTimeout(properties, "connectTimeout", 5000);
        this.name = properties.get("name");
        this.enabled = this.parseEnabled(properties);
        HashMap<String, Variant> stateProps = new HashMap<String, Variant>();
        stateProps.put("host", Variant.valueOf((Object)this.host));
        stateProps.put("port", Variant.valueOf((Object)this.port));
        stateProps.put("enabled", Variant.valueOf((boolean)this.enabled));
        this.stateItem.updateData(null, stateProps, AttributeMode.UPDATE);
        AbstractConnectionDevice abstractConnectionDevice = this;
        synchronized (abstractConnectionDevice) {
            this.disconnect();
            if (this.enabled) {
                this.connect();
            }
        }
    }

    private boolean parseEnabled(Map<String, String> properties) {
        String str = properties.get("disabled");
        if (str == null) {
            return true;
        }
        return !Boolean.parseBoolean(str);
    }

    protected static int getTimeout(Map<String, String> properties, String specificTimeoutKey, int defaultValue) {
        String timeout = properties.get(specificTimeoutKey);
        if (timeout != null) {
            return Integer.valueOf(timeout);
        }
        timeout = properties.get("timeout");
        if (timeout != null) {
            return Integer.valueOf(timeout);
        }
        return defaultValue;
    }

    private synchronized void connect() {
        if (this.state != ConnectionState.DISCONNECTED) {
            logger.warn("Tried to connect in state: {}", (Object)this.state);
            return;
        }
        if (this.session != null) {
            logger.error("We already have a session: {}", (Object)this.session);
            logger.error("Connect error", new IllegalStateException().fillInStackTrace());
            return;
        }
        if (this.connector == null) {
            this.connector = this.processor != null ? new NioSocketConnector((IoProcessor)this.processor) : new NioSocketConnector();
            this.connector.setHandler(this.handler);
            this.configureConnector(this.connector);
            this.connector.setConnectTimeoutMillis((long)this.connectTimeout);
        }
        this.setState(ConnectionState.CONNECTING);
        ConnectFuture future = this.connector.connect((SocketAddress)new InetSocketAddress(this.host, (int)this.port.shortValue()));
        future.addListener((IoFutureListener)new IoFutureListener<IoFuture>(){

            public void operationComplete(IoFuture future) {
                try {
                    AbstractConnectionDevice.this.setSession(future.getSession());
                }
                catch (Exception e) {
                    AbstractConnectionDevice.this.disconnected(e);
                }
            }
        });
    }

    protected abstract void configureConnector(NioSocketConnector var1);

    private void setState(ConnectionState state) {
        this.state = state;
        this.stateItem.updateData(Variant.valueOf((Object)state.toString()), null, null);
        this.connectionItem.updateData(Variant.valueOf((state == ConnectionState.CONNECTED ? 1 : 0) != 0), null, null);
    }

    protected synchronized void setSession(IoSession session) {
        if (this.session != null && session != null) {
            logger.error("We already have a session set!", (Throwable)new IllegalStateException());
        }
        if (session != null) {
            this.setState(ConnectionState.CONNECTED);
        } else {
            logger.info("Disconnected");
            this.setState(ConnectionState.DISCONNECTED);
            this.handleSessionDisconnected();
        }
        this.session = session;
    }

    protected void handleSessionDisconnected() {
    }

    private synchronized void disconnected(Exception e) {
        if (this.disposed.get()) {
            return;
        }
        this.stateItem.updateData(null, Collections.singletonMap("connectionError", Variant.valueOf((Object)ExceptionHelper.getMessage((Throwable)e))), AttributeMode.UPDATE);
        this.setSession(null);
        if (this.enabled) {
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    AbstractConnectionDevice.this.connect();
                }
            }, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void disconnect() {
        if (this.session != null) {
            if (!this.session.isClosing()) {
                logger.info("Close session: {}", (Object)this.session);
                this.session.close(true);
            } else {
                logger.warn("Session already closing: {}", (Object)this.session);
            }
        } else {
            logger.warn("Disconnected without session");
        }
    }

    protected synchronized void handleExceptionCaught(IoSession session, Throwable error) throws Exception {
        logger.warn("Exception caught", error);
        this.checkSession(session);
        if (!(error instanceof WrongSessionException)) {
            this.disconnect();
        }
    }

    protected synchronized void handleMessageReceived(IoSession session, Object message) throws Exception {
        logger.debug("Message received: {}", message);
        this.checkSession(session);
    }

    protected synchronized void handleMessageSent(IoSession session, Object message) throws Exception {
        logger.debug("Message sent: {}", message);
        this.checkSession(session);
    }

    protected void checkSession(IoSession session) {
        if (this.session != session && this.session != null) {
            logger.warn("Wrong session called: {} <-> {}", (Object)this.session, (Object)session);
            throw new WrongSessionException();
        }
    }

    protected synchronized void handleSessionClosed(IoSession session) throws Exception {
        logger.warn("Connection lost: {}", (Object)session);
        if (this.session != null) {
            this.checkSession(session);
        }
        this.disconnected(null);
    }

    protected synchronized void handleSessionCreated(IoSession session) throws Exception {
        logger.info("Session created: {}", (Object)session);
    }

    protected synchronized void handleSessionIdle(IoSession session, IdleStatus status) throws Exception {
        logger.warn("Got idle: {} / {}", (Object)status, (Object)session);
        this.checkSession(session);
        this.disconnect();
    }

    protected synchronized void handleSessionOpened(IoSession session) throws Exception {
        logger.info("Session opened: {}", (Object)session);
        if (this.session != null) {
            this.checkSession(session);
        }
    }

    protected static enum ConnectionState {
        CONNECTING,
        CONNECTED,
        DISCONNECTED;

    }
}

