/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.server.common.chain.DataItemInputOutputChained;
import org.eclipse.scada.da.server.common.memory.ScalarVariable;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class MemoryDeviceDataitem
extends DataItemInputOutputChained {
    private final ScalarVariable variable;

    public MemoryDeviceDataitem(String itemId, Executor executor, ScalarVariable variable) {
        super(itemId, executor);
        this.variable = variable;
    }

    protected WriteAttributeResults handleUnhandledAttributes(WriteAttributeResults initialResults, Map<String, Variant> attributes) {
        WriteAttributeResults writeAttributeResults = initialResults;
        if (writeAttributeResults == null) {
            writeAttributeResults = new WriteAttributeResults();
        }
        HashMap<String, Variant> requests = new HashMap<String, Variant>(0);
        for (Map.Entry<String, Variant> entry : attributes.entrySet()) {
            if (writeAttributeResults.containsKey((Object)entry.getKey())) continue;
            requests.put(entry.getKey(), entry.getValue());
        }
        writeAttributeResults.putAll(this.variable.handleAttributes(requests));
        return super.handleUnhandledAttributes(writeAttributeResults, attributes);
    }

    protected NotifyFuture<WriteResult> startWriteCalculatedValue(Variant value, OperationParameters operationParameters) {
        try {
            return this.variable.handleWrite(value);
        }
        catch (Exception e) {
            return new InstantErrorFuture((Throwable)e);
        }
    }
}

