/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.impl.stats;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.common.impl.stats.CounterOutput;
import org.eclipse.scada.da.server.common.impl.stats.CounterOutputMXBeanImpl;
import org.eclipse.scada.utils.concurrent.DirectExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItemCounterOutput
implements CounterOutput {
    private static final Logger logger = LoggerFactory.getLogger(DataItemCounterOutput.class);
    private final DataItemInputChained averageItem;
    private final DataItemInputChained totalItem;
    private final MBeanServer mbs;
    private final CounterOutputMXBeanImpl export;
    private ObjectInstance exportInstance;
    private ObjectInstance totalInstance;
    private final String itemId;

    public DataItemCounterOutput(String itemId) {
        this.itemId = itemId;
        this.averageItem = new DataItemInputChained(String.valueOf(itemId) + ".average", DirectExecutor.INSTANCE);
        this.totalItem = new DataItemInputChained(String.valueOf(itemId) + ".total", DirectExecutor.INSTANCE);
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        this.export = new CounterOutputMXBeanImpl();
    }

    @Override
    public void register(HiveCommon hive, FolderCommon rootFolder, String description) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        hive.registerItem(this.averageItem);
        attributes.put("description", Variant.valueOf((Object)(String.valueOf(description) + " - Average value")));
        rootFolder.add(this.averageItem.getInformation().getName(), this.averageItem, attributes);
        attributes.clear();
        hive.registerItem(this.totalItem);
        attributes.put("description", Variant.valueOf((Object)(String.valueOf(description) + " - Total counter")));
        rootFolder.add(this.totalItem.getInformation().getName(), this.totalItem, attributes);
        try {
            this.exportInstance = this.mbs.registerMBean(this.export, this.makeName(String.valueOf(hive.getHiveId()) + ".stats", this.itemId));
        }
        catch (Exception e) {
            logger.warn("Failed to export statistics", (Throwable)e);
        }
    }

    private ObjectName makeName(String domain, String description) throws MalformedObjectNameException, NullPointerException {
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        properties.put("value", description);
        return new ObjectName(domain, properties);
    }

    @Override
    public void unregister(HiveCommon hive, FolderCommon rootFolder) {
        rootFolder.remove(this.averageItem);
        hive.unregisterItem(this.averageItem);
        rootFolder.remove(this.totalItem);
        hive.unregisterItem(this.totalItem);
        if (this.exportInstance != null) {
            try {
                this.mbs.unregisterMBean(this.exportInstance.getObjectName());
            }
            catch (Exception e) {
                logger.warn("Failed to unregister average", (Throwable)e);
            }
            this.exportInstance = null;
        }
        if (this.totalInstance != null) {
            try {
                this.mbs.unregisterMBean(this.totalInstance.getObjectName());
            }
            catch (Exception e) {
                logger.warn("Failed to unregister total", (Throwable)e);
            }
            this.totalInstance = null;
        }
    }

    @Override
    public void setTickValue(double average, long total) {
        this.averageItem.updateData(Variant.valueOf((double)average), null, null);
        this.totalItem.updateData(Variant.valueOf((long)total), null, null);
        this.export.setAverage(average);
        this.export.setTotal(total);
    }
}

