/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.impl.stats;

import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.common.session.AbstractSessionImpl;
import org.eclipse.scada.da.core.server.Session;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.impl.stats.CounterValue;
import org.eclipse.scada.da.server.common.impl.stats.HiveEventListener;
import org.eclipse.scada.da.server.common.impl.stats.Tickable;

public class HiveStatisticsGenerator
implements HiveEventListener,
Tickable {
    protected CounterValue itemsValue = new CounterValue();
    protected CounterValue sessionsValue = new CounterValue();
    protected CounterValue valueWritesCounter = new CounterValue();
    protected CounterValue attributeWritesCounter = new CounterValue();
    protected CounterValue valueEventsCounter = new CounterValue();
    protected CounterValue attributeEventsCounter = new CounterValue();

    @Override
    public void itemRegistered(DataItem item) {
        this.itemsValue.add(1L);
    }

    @Override
    public void sessionCreated(AbstractSessionImpl session) {
        this.sessionsValue.add(1L);
    }

    @Override
    public void sessionDestroyed(AbstractSessionImpl session) {
        this.sessionsValue.add(-1L);
    }

    @Override
    public void startWrite(Session session, String itemName, Variant value) {
        this.valueWritesCounter.add(1L);
    }

    @Override
    public void startWriteAttributes(Session session, String itemId, int size) {
        this.attributeWritesCounter.add(size);
    }

    @Override
    public void attributesChanged(DataItem item, int size) {
        this.attributeEventsCounter.add(size);
    }

    @Override
    public void valueChanged(DataItem item, Variant variant, boolean cache) {
        this.valueEventsCounter.add(1L);
    }

    @Override
    public void tick() {
        this.attributeWritesCounter.tick();
        this.itemsValue.tick();
        this.sessionsValue.tick();
        this.valueWritesCounter.tick();
        this.valueEventsCounter.tick();
        this.attributeEventsCounter.tick();
    }

    @Override
    public void itemUnregistered(DataItem item) {
        this.itemsValue.add(-1L);
    }
}

