/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter;

import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.exporter.Export;
import org.eclipse.scada.da.server.net.Exporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetExport
implements Export {
    private static final Logger logger = LoggerFactory.getLogger(NetExport.class);
    private Hive hive = null;
    private Exporter exporter = null;
    private final ConnectionInformation connectionInformation;

    public NetExport(Hive hive, ConnectionInformation connectionInformation) throws Exception {
        this.hive = hive;
        this.connectionInformation = connectionInformation;
        logger.debug("Instatiate exporter class");
        this.exporter = new Exporter(this.hive, this.connectionInformation);
    }

    public synchronized void start() throws Exception {
        if (this.exporter == null) {
            return;
        }
        logger.info("Starting exporter ({}) on port {}", (Object)this.hive, (Object)this.connectionInformation);
        this.exporter.start();
    }

    public void stop() throws Exception {
        this.exporter.stop();
    }

    @Override
    public ConnectionInformation getConnectionInformation() {
        return this.connectionInformation;
    }
}

