/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.osgi.modbus;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.server.osgi.modbus.MasterFactory;
import org.eclipse.scada.da.server.osgi.modbus.SlaveFactory;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.concurrent.ScheduledExportedExecutorService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private MasterFactory masterFactory;
    private SlaveFactory slaveFactory;
    private ServiceRegistration<ConfigurationFactory> masterFactoryHandle;
    private ServiceRegistration<ConfigurationFactory> slaveFactoryHandle;
    private ScheduledExportedExecutorService executor;
    private NioProcessor processor;

    public void start(BundleContext context) throws Exception {
        this.executor = new ScheduledExportedExecutorService("org.eclipse.scada.da.server.osgi.modbus", 1);
        this.processor = new NioProcessor((Executor)Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("org.eclipse.scada.da.server.osgi.modbus.NioProcessor")));
        this.masterFactory = new MasterFactory(context, (ScheduledExecutorService)this.executor, this.processor);
        this.slaveFactory = new SlaveFactory(context, this.masterFactory, (Executor)this.executor);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "Modbus master device factory");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.server.osgi.modbus.masterDevice");
        this.masterFactoryHandle = context.registerService(ConfigurationFactory.class, (Object)this.masterFactory, properties);
        properties = new Hashtable();
        ((Dictionary)properties).put("service.description", "Modbus slave device factory");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.server.osgi.modbus.slaveDevice");
        this.slaveFactoryHandle = context.registerService(ConfigurationFactory.class, (Object)this.slaveFactory, properties);
    }

    public void stop(BundleContext context) throws Exception {
        this.masterFactoryHandle.unregister();
        this.masterFactory.dispose();
        this.slaveFactoryHandle.unregister();
        this.slaveFactory.dispose();
        this.processor.dispose();
        this.executor.shutdown();
    }
}

