/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.test.items;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.AttributeManager;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemBase;
import org.eclipse.scada.da.server.common.DataItemOutput;
import org.eclipse.scada.da.server.common.WriteAttributesHelper;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.chain.MemoryItemChained;
import org.eclipse.scada.da.server.test.Hive;
import org.eclipse.scada.da.server.test.items.MemoryChainedItem;
import org.eclipse.scada.utils.collection.MapBuilder;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class MemoryCellItem
extends DataItemOutput {
    private final Hive hive;
    private Map<Integer, MemoryItemChained> items = new HashMap<Integer, MemoryItemChained>();
    private AttributeManager attributes = null;
    private FolderCommon folder = null;

    public MemoryCellItem(Hive hive, String name, FolderCommon folder) {
        super(name);
        this.hive = hive;
        this.folder = folder;
        this.attributes = new AttributeManager((DataItemBase)this);
        this.updateCells(0);
    }

    public Map<String, Variant> getAttributes() {
        return this.attributes.getCopy();
    }

    public NotifyFuture<WriteAttributeResults> startSetAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        return new InstantFuture((Object)WriteAttributesHelper.errorUnhandled(null, attributes));
    }

    public NotifyFuture<WriteResult> startWriteValue(Variant value, OperationParameters operationParameters) {
        try {
            int num = value.asInteger();
            this.updateCells(num);
            return new InstantFuture((Object)WriteResult.OK);
        }
        catch (Throwable e) {
            return new InstantErrorFuture(e);
        }
    }

    private void setSizeAttribute(int num) {
        this.attributes.update("size", Variant.valueOf((int)num));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCells(int num) {
        if (num < 0) {
            num = 0;
        }
        Map<Integer, MemoryItemChained> map = this.items;
        synchronized (map) {
            HashMap<Integer, MemoryItemChained> newItems = new HashMap<Integer, MemoryItemChained>(num);
            int pos = 0;
            while (pos < num && pos < this.items.size()) {
                if (this.items.containsKey(pos)) {
                    newItems.put(pos, this.items.get(pos));
                    this.items.remove(pos);
                }
                ++pos;
            }
            for (Map.Entry<Integer, MemoryItemChained> entry : this.items.entrySet()) {
                this.folder.remove(entry.getKey().toString());
                this.hive.unregisterItem((DataItem)entry.getValue());
            }
            int i = pos;
            while (i < num) {
                MemoryItemChained item = new MemoryItemChained(String.valueOf(this.getInformation().getName()) + "-" + i);
                MemoryChainedItem.applyDefaultInputChain(this.hive, (DataItemInputChained)item);
                this.hive.registerItem((DataItem)item);
                this.folder.add(String.valueOf(i), (DataItem)item, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)("Cell #" + i + " of " + num + " automaticall provided memory cells."))).getMap());
                newItems.put(i, item);
                ++i;
            }
            this.items = newItems;
            this.setSizeAttribute(num);
        }
    }
}

