/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details.part;

import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.client.dataitem.details.VisibilityController;
import org.eclipse.scada.da.client.dataitem.details.part.DetailsPart;
import org.eclipse.scada.da.ui.connection.data.DataItemHolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractBaseDetailsPart
implements DetailsPart {
    protected Display display;
    protected DataItemHolder item;
    protected DataItemValue value;
    protected Shell shell;
    private boolean disposed;

    protected void setShell(Shell shell) {
        this.shell = shell;
        this.display = shell.getDisplay();
    }

    @Override
    public void createPart(Composite parent) {
        this.setShell(parent.getShell());
    }

    @Override
    public void setDataItem(DataItemHolder item) {
        this.item = item;
    }

    public void dispose() {
        this.disposed = true;
    }

    @Override
    public void updateData(DataItemValue value) {
        this.value = value;
        if (!this.disposed) {
            this.update();
        }
    }

    protected abstract void update();

    protected boolean isUnsafe() {
        return this.value.isError() || !this.value.isConnected();
    }

    protected boolean isError() {
        return this.value.isError();
    }

    protected boolean isAlarm() {
        return this.value.isAlarm();
    }

    protected boolean isManual() {
        return this.value.isManual();
    }

    protected boolean isForceActive() {
        return Boolean.getBoolean("org.eclipse.scada.da.client.dataitem.details.extra.forceActive");
    }

    protected boolean getBooleanAttribute(String name) {
        if (this.value.getAttributes().containsKey(name)) {
            return ((Variant)this.value.getAttributes().get(name)).asBoolean();
        }
        return false;
    }

    protected DataItemValue getValue() {
        return this.value;
    }

    protected Number getNumberAttribute(String name, Number defaultValue) {
        Variant value = (Variant)this.value.getAttributes().get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value.isNull()) {
            return defaultValue;
        }
        try {
            if (value.isDouble()) {
                return value.asDouble();
            }
            if (value.isInteger()) {
                return value.asInteger();
            }
            if (value.isLong()) {
                return value.asLong();
            }
            if (value.isBoolean()) {
                return value.asBoolean() ? 1 : 0;
            }
            return Double.parseDouble(value.asString());
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    protected boolean hasAttribute(String attributeName) {
        DataItemValue value = this.value;
        if (value == null) {
            return false;
        }
        if (value.getAttributes() == null) {
            return false;
        }
        return value.getAttributes().containsKey(attributeName);
    }

    @Override
    public void setVisibilityController(VisibilityController visibilityController) {
        visibilityController.show();
    }
}

