/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details.part.overview;

import java.util.Calendar;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.da.client.dataitem.details.part.AbstractBaseDetailsPart;
import org.eclipse.scada.da.client.dataitem.details.part.overview.Messages;
import org.eclipse.scada.da.ui.connection.data.DataItemHolder;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OverviewDetailsPart
extends AbstractBaseDetailsPart {
    private Text connectionUriText;
    private Text itemIdText;
    private Text stateText;
    private Text alarmText;
    private Text errorText;
    private Text valueText;
    private Text timestampText;
    private Text manualText;
    private Text blockedText;
    private Text warnText;

    @Override
    public void createPart(Composite parent) {
        super.createPart(parent);
        parent.setLayout((Layout)new FillLayout());
        parent.setBackgroundMode(2);
        ScrolledComposite scroll = new ScrolledComposite(parent, 512);
        scroll.setBackgroundMode(2);
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        Composite wrapper = new Composite((Composite)scroll, 0);
        wrapper.setLayout((Layout)new GridLayout(2, false));
        scroll.setContent((Control)wrapper);
        Label label = new Label(wrapper, 0);
        label.setText(Messages.OverviewDetailsPart_ConnectionLabel);
        this.connectionUriText = new Text(wrapper, 2056);
        this.connectionUriText.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label(wrapper, 0);
        label.setText(Messages.OverviewDetailsPart_ItemIdLabel);
        this.itemIdText = new Text(wrapper, 2056);
        this.itemIdText.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label(wrapper, 0);
        label.setText(Messages.OverviewDetailsPart_SubscriptionStateLabel);
        this.stateText = new Text(wrapper, 2056);
        this.stateText.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label(wrapper, 0);
        label.setText(Messages.OverviewDetailsPart_WarningLabel);
        this.warnText = new Text(wrapper, 2056);
        this.warnText.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label(wrapper, 0);
        label.setText(Messages.OverviewDetailsPart_AlarmLabel);
        this.alarmText = new Text(wrapper, 2056);
        this.alarmText.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label(wrapper, 0);
        label.setText(Messages.OverviewDetailsPart_ErrorLabel);
        this.errorText = new Text(wrapper, 2056);
        this.errorText.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label(wrapper, 0);
        label.setText(Messages.OverviewDetailsPart_ManualLabel);
        this.manualText = new Text(wrapper, 2056);
        this.manualText.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label(wrapper, 0);
        label.setText(Messages.OverviewDetailsPart_BlockedLabel);
        this.blockedText = new Text(wrapper, 2056);
        this.blockedText.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label(wrapper, 0);
        label.setText(Messages.OverviewDetailsPart_ValueLabel);
        this.valueText = new Text(wrapper, 2056);
        this.valueText.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label(wrapper, 0);
        label.setText(Messages.OverviewDetailsPart_TimestampLabel);
        this.timestampText = new Text(wrapper, 2056);
        this.timestampText.setLayoutData((Object)new GridData(4, 1, true, false));
        scroll.setMinSize(wrapper.computeSize(-1, -1));
    }

    @Override
    public void setDataItem(DataItemHolder item) {
        super.setDataItem(item);
        if (item != null) {
            this.connectionUriText.setText(this.getConnectionString(item));
            this.itemIdText.setText(item.getItem().getId());
        } else {
            this.connectionUriText.setText("");
            this.itemIdText.setText("");
            this.stateText.setText("");
            this.warnText.setText("");
            this.alarmText.setText("");
            this.errorText.setText("");
            this.manualText.setText("");
            this.blockedText.setText("");
            this.valueText.setText("");
            this.timestampText.setText("");
        }
    }

    private String getConnectionString(DataItemHolder itemHolder) {
        if (itemHolder == null || itemHolder.getItem() == null) {
            return "";
        }
        Item item = itemHolder.getItem();
        if (item == null) {
            return "";
        }
        String str = item.getConnectionString();
        try {
            ConnectionInformation ci = ConnectionInformation.fromURI((String)str);
            return ci.toMaskedString();
        }
        catch (Exception exception) {
            return str;
        }
    }

    @Override
    protected void update() {
        if (this.value == null) {
            return;
        }
        if (this.value.getSubscriptionError() == null) {
            this.stateText.setText(this.value.getSubscriptionState().name());
        } else {
            this.stateText.setText(String.format(Messages.OverviewDetailsPart_SubscriptionStateFormat, this.value.getSubscriptionState().name(), this.value.getSubscriptionError().getMessage()));
        }
        this.warnText.setText(this.value.isWarning() ? Messages.OverviewDetailsPart_WarningActiveText : Messages.OverviewDetailsPart_WarningInactiveText);
        this.alarmText.setText(this.value.isAlarm() ? Messages.OverviewDetailsPart_AlarmActiveText : Messages.OverviewDetailsPart_AlarmInactiveText);
        this.errorText.setText(this.value.isError() ? Messages.OverviewDetailsPart_ErrorActiveText : Messages.OverviewDetailsPart_ErrorInactiveText);
        this.manualText.setText(this.value.isManual() ? Messages.OverviewDetailsPart_ManualActiveText : Messages.OverviewDetailsPart_ManualInactiveText);
        this.blockedText.setText(this.value.isBlocked() ? Messages.OverviewDetailsPart_BlockedActiveText : Messages.OverviewDetailsPart_BlockedInactiveText);
        this.valueText.setText(this.value.getValue() != null ? this.value.getValue().toString() : Messages.OverviewDetailsPart_NullText);
        Calendar c = this.value.getTimestamp();
        this.timestampText.setText(c != null ? String.format(Messages.OverviewDetailsPart_TimeFormat, c) : Messages.OverviewDetailsPart_NullText);
    }
}

