/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.client.test.wizards;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.ui.common.ValueType;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.connection.data.ItemSelectionHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteOperationWizardValuePage
extends WizardPage
implements IWizardPage {
    private static final Logger logger = LoggerFactory.getLogger(WriteOperationWizardValuePage.class);
    private Text itemIdText;
    private Text valueText;
    private Combo valueTypeSelect;
    private Text convertedValue;
    private Color defaultValueColor;
    private Variant value;
    private Item item;

    protected WriteOperationWizardValuePage() {
        super("wizardPage");
        this.setTitle("Write Data Item");
        this.setDescription("Enter the information to write");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Item:");
        this.itemIdText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.itemIdText.setLayoutData((Object)gd);
        this.itemIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WriteOperationWizardValuePage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label = new Label(container, 0);
        label.setText("&Value:");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.valueText = new Text(container, 2050);
        gd = new GridData(4, 4, true, true);
        this.valueText.setLayoutData((Object)gd);
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WriteOperationWizardValuePage.this.dialogChanged();
            }
        });
        this.valueTypeSelect = new Combo(container, 12);
        ValueType[] valueTypeArray = ValueType.values();
        int n = valueTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValueType vt = valueTypeArray[n2];
            this.valueTypeSelect.add(vt.label(), vt.ordinal());
            ++n2;
        }
        this.valueTypeSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WriteOperationWizardValuePage.this.dialogChanged();
            }
        });
        this.valueTypeSelect.select(ValueType.STRING.ordinal());
        this.valueTypeSelect.setLayoutData((Object)new GridData(1, 1, false, false));
        label = new Label(container, 0);
        label.setText("Converted Value: ");
        this.convertedValue = new Text(container, 2060);
        gd = new GridData(768);
        this.convertedValue.setLayoutData((Object)gd);
        this.defaultValueColor = this.convertedValue.getForeground();
        this.setControl((Control)container);
        this.updateSelection();
        this.dialogChanged();
    }

    private void updateSelection() {
        if (this.item != null) {
            this.itemIdText.setText(this.item.getId());
        } else {
            this.itemIdText.setText("");
        }
    }

    private void setValueText(String value, boolean systemText) {
        this.convertedValue.setText(value);
        if (systemText) {
            Color color = this.convertedValue.getDisplay().getSystemColor(3);
            this.convertedValue.setForeground(color);
        } else {
            this.convertedValue.setForeground(this.defaultValueColor);
        }
    }

    private void dialogChanged() {
        if (this.item == null) {
            this.updateStatus("No item selection");
            return;
        }
        if (this.itemIdText.getText().length() <= 0) {
            this.updateStatus("Item name must not be empty");
            return;
        }
        this.setValueText("<not set>", true);
        this.value = null;
        int idx = this.valueTypeSelect.getSelectionIndex();
        try {
            ValueType[] valueTypeArray = ValueType.values();
            int n = valueTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValueType vt = valueTypeArray[n2];
                if (vt.ordinal() == idx) {
                    this.value = vt.convertTo(this.valueText.getText());
                }
                ++n2;
            }
        }
        catch (NotConvertableException e) {
            this.updateStatus("Unable to convert value to target type: " + e.getMessage());
            return;
        }
        catch (Exception e) {
            logger.error("Failed to convert", (Throwable)e);
        }
        if (this.value != null) {
            try {
                this.setValueText(this.value.asString(), false);
            }
            catch (NullValueException nullValueException) {
                this.setValueText("<null>", true);
            }
        } else {
            this.setValueText("no converter found for: " + idx, true);
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public Item getItem() {
        return new Item(this.item.getConnectionString(), this.itemIdText.getText(), this.item.getType());
    }

    public Variant getValue() {
        return this.value;
    }

    public void setSelection(IStructuredSelection selection) {
        this.item = ItemSelectionHelper.getFirstFromSelection((ISelection)selection);
    }
}

