/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.widgets.realtime;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scada.da.ui.widgets.realtime.AttributePair;
import org.eclipse.scada.da.ui.widgets.realtime.ListData;
import org.eclipse.scada.da.ui.widgets.realtime.ListEntry;
import org.eclipse.scada.da.ui.widgets.realtime.Listener;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemListContentProvider
implements ITreeContentProvider,
Listener {
    private static final Logger logger = LoggerFactory.getLogger(ItemListContentProvider.class);
    private Viewer viewer = null;
    private ListData data = null;
    private Display display;

    public Object[] getChildren(Object parentElement) {
        if (this.data == null) {
            return null;
        }
        if (parentElement instanceof ListData) {
            ListData listData = (ListData)parentElement;
            return listData.getItems().toArray(new ListEntry[0]);
        }
        if (parentElement instanceof ListEntry) {
            return ((ListEntry)parentElement).getAttributes().toArray(new AttributePair[0]);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (this.data == null) {
            return null;
        }
        if (element instanceof ListEntry) {
            return this.data;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.data == null) {
            return false;
        }
        if (element instanceof ListEntry) {
            return ((ListEntry)element).hasAttributes();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.unsubscribe();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.unsubscribe();
        this.viewer = viewer;
        if (viewer != null) {
            this.display = viewer.getControl().getDisplay();
        }
        if (newInput != null) {
            this.subcribe(newInput);
        }
    }

    private void subcribe(Object newInput) {
        if (!(newInput instanceof ListData)) {
            return;
        }
        this.data = (ListData)newInput;
        this.data.addListener(this);
    }

    private void unsubscribe() {
        if (this.data != null) {
            this.data.removeListener(this);
            this.data = null;
        }
    }

    @Override
    public void added(final ListEntry[] entries) {
        try {
            if (this.viewer != null) {
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ItemListContentProvider.this.performAdded(entries);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.warn("Failed to notify viewer", (Throwable)e);
        }
    }

    protected void performAdded(ListEntry[] entries) {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        if (this.viewer instanceof TreeViewer) {
            ((TreeViewer)this.viewer).add((Object)this.data, (Object[])entries);
        } else if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    @Override
    public void removed(final ListEntry[] entries) {
        try {
            if (this.viewer != null) {
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ItemListContentProvider.this.performRemoved(entries);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.warn("Failed to notify viewer", (Throwable)e);
        }
    }

    public void performRemoved(ListEntry[] entries) {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        if (this.viewer instanceof TreeViewer) {
            ((TreeViewer)this.viewer).remove((Object[])entries);
        } else if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    @Override
    public void updated(final ListEntry[] entries) {
        try {
            if (this.viewer != null) {
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ItemListContentProvider.this.performUpdated(entries);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.warn("Failed to notify viewer", (Throwable)e);
        }
    }

    public void performUpdated(ListEntry[] entries) {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        if (this.viewer instanceof TreeViewer) {
            ListEntry[] listEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ListEntry entry = listEntryArray[n2];
                ((TreeViewer)this.viewer).refresh((Object)entry);
                ++n2;
            }
            ((TreeViewer)this.viewer).update((Object[])entries, null);
        } else if (this.viewer != null) {
            this.viewer.refresh();
        }
    }
}

