/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ds.storage.jdbc.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.eclipse.scada.ds.DataNode;
import org.eclipse.scada.ds.storage.jdbc.internal.JdbcStorageDao;
import org.eclipse.scada.utils.osgi.jdbc.CommonConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.pool.PoolConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.task.CommonConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionContext;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.RowCallback;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStorageDaoBlobImpl
implements JdbcStorageDao {
    private static final Logger logger = LoggerFactory.getLogger(JdbcStorageDaoBlobImpl.class);
    private static final String TABLE_NAME = System.getProperty("org.eclipse.scada.ds.storage.jdbc.table", "datastore");
    private static final String SQL_SELECT = String.format("select node_id, data from %s where node_id=? and instance_id=?", TABLE_NAME);
    private static final String SQL_SELECT_ALL = String.format("select node_id, data from %s where instance_id=?", TABLE_NAME);
    private static final String SQL_INSERT = String.format("insert into %s ( node_id, instance_id, data ) values ( ? , ?, ? )", TABLE_NAME);
    private static final String SQL_DELETE = String.format("delete from %s where node_id=? and instance_id=?", TABLE_NAME);
    private final String instanceId = System.getProperty("org.eclipse.scada.ds.storage.jdbc.instance", "default");
    private final CommonConnectionAccessor accessor;

    public JdbcStorageDaoBlobImpl(DataSourceFactory dataSourceFactory, Properties paramProperties, boolean usePool) throws SQLException {
        this.accessor = usePool ? new PoolConnectionAccessor(dataSourceFactory, paramProperties) : new DataSourceConnectionAccessor(dataSourceFactory, paramProperties);
    }

    @Override
    public DataNode readNode(final String nodeId) {
        List result = (List)this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<List<DataNode>>(){

            protected List<DataNode> performTask(ConnectionContext connectionContext) throws Exception {
                CollectRows innerResult = new CollectRows(new LinkedList<DataNode>());
                connectionContext.query((RowCallback)innerResult, SQL_SELECT, new Object[]{nodeId, JdbcStorageDaoBlobImpl.this.instanceId});
                return innerResult.getResult();
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return (DataNode)result.get(0);
    }

    @Override
    public Collection<DataNode> readAllNodes() {
        return (Collection)this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<List<DataNode>>(){

            protected List<DataNode> performTask(ConnectionContext connectionContext) throws Exception {
                CollectRows innerResult = new CollectRows(new LinkedList<DataNode>());
                connectionContext.query((RowCallback)innerResult, SQL_SELECT_ALL, new Object[]{JdbcStorageDaoBlobImpl.this.instanceId});
                return innerResult.getResult();
            }
        });
    }

    @Override
    public void deleteNode(final String nodeId) {
        this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Void>(){

            protected Void performTask(ConnectionContext connectionContext) throws Exception {
                JdbcStorageDaoBlobImpl.this.deleteNode(nodeId);
                return null;
            }
        });
    }

    protected void deleteNode(ConnectionContext connectionContext, String nodeId) throws SQLException {
        connectionContext.update(SQL_DELETE, new Object[]{nodeId, this.instanceId});
    }

    @Override
    public void writeNode(final DataNode node) {
        logger.debug("Write data node: {}", (Object)node);
        this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Void>(){

            protected Void performTask(ConnectionContext connectionContext) throws Exception {
                connectionContext.getConnection().setAutoCommit(false);
                JdbcStorageDaoBlobImpl.this.deleteNode(connectionContext, node.getId());
                connectionContext.update(SQL_INSERT, new Object[]{node.getId(), JdbcStorageDaoBlobImpl.this.instanceId, node.getData()});
                connectionContext.commit();
                return null;
            }
        });
    }

    @Override
    public void dispose() {
        this.accessor.dispose();
    }

    public static class CollectRows
    implements RowCallback {
        private final List<DataNode> result;

        public CollectRows(List<DataNode> result) {
            this.result = result;
        }

        public void processRow(ResultSet resultSet) throws SQLException {
            this.result.add(new DataNode(resultSet.getString("node_id"), resultSet.getBytes("data")));
        }

        public List<DataNode> getResult() {
            return this.result;
        }
    }
}

