/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.exporter.http.server.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scada.hd.exporter.http.HttpExporter;
import org.eclipse.scada.hd.exporter.http.Utils;
import org.eclipse.scada.hd.exporter.http.server.internal.NotAvailableHttpExporter;

public class JsonServlet
extends HttpServlet {
    private static final long serialVersionUID = -2152989291571139312L;
    private final HttpExporter fallbackExporter = new NotAvailableHttpExporter();
    private final AtomicReference<HttpExporter> exporter = new AtomicReference<HttpExporter>(this.fallbackExporter);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getPathInfo() == null) {
            this.send404Error(request, response);
            return;
        }
        if (request.getPathInfo().startsWith("/items")) {
            String[] parts = request.getPathInfo().split("/");
            switch (parts.length) {
                case 2: {
                    this.sendAvailableItems(request, response);
                    return;
                }
                case 3: {
                    this.sendAvailableSeries(request, response, parts[2]);
                    return;
                }
                case 4: {
                    this.sendData(request, response, parts[2], parts[3]);
                    return;
                }
            }
            this.send404Error(request, response);
            return;
        }
        if (request.getPathInfo().equals("/info")) {
            this.sendInfo(request, response);
        } else {
            this.send404Error(request, response);
        }
    }

    private void send404Error(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(404);
    }

    private void sendInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
        pw.println("current Exporter is: " + this.exporter.get().getClass().getCanonicalName());
        pw.close();
    }

    private void sendAvailableItems(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.setHeaders(request, response);
        PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
        try {
            pw.println(Utils.gson.toJson((Object)this.exporter.get().getItems()));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        pw.close();
    }

    private void sendAvailableSeries(HttpServletRequest request, HttpServletResponse response, String itemId) throws IOException, ServletException {
        this.setHeaders(request, response);
        PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
        try {
            pw.println(Utils.gson.toJson((Object)this.exporter.get().getSeries(itemId)));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        pw.close();
    }

    private void sendData(HttpServletRequest request, HttpServletResponse response, String itemId, String type) throws IOException, ServletException {
        this.setHeaders(request, response);
        Date from = this.requiredDate(request, "from");
        Date to = this.requiredDate(request, "to");
        Integer number = this.requiredInteger(request, "no");
        PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
        try {
            pw.println(Utils.gson.toJson((Object)this.exporter.get().getData(itemId, type, from, to, number)));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        pw.close();
    }

    private void setHeaders(HttpServletRequest request, HttpServletResponse response) {
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            response.setContentType("application/json");
        } else {
            response.setContentType("application/javascript");
        }
        if (request.getAttribute("debug") != null) {
            response.setContentType("application/javascript");
        }
        response.setCharacterEncoding("UTF-8");
    }

    private String requiredString(HttpServletRequest request, String parameter) throws ServletException {
        String result = request.getParameter(parameter);
        if (result == null) {
            throw new ServletException("parameter '" + parameter + "' does not exist");
        }
        return result;
    }

    private Integer requiredInteger(HttpServletRequest request, String parameter) throws ServletException {
        String intToParse = this.requiredString(request, parameter);
        try {
            return Integer.parseInt(intToParse);
        }
        catch (NumberFormatException e) {
            throw new ServletException("parameter '" + parameter + "' threw " + e.getMessage());
        }
    }

    private Date requiredDate(HttpServletRequest request, String parameter) throws ServletException {
        String dateToParse = this.requiredString(request, parameter);
        try {
            return Utils.isoDateFormat.parse(dateToParse);
        }
        catch (ParseException e) {
            throw new ServletException("parameter '" + parameter + "' threw " + e.getMessage());
        }
    }

    public HttpExporter getExporter() {
        return this.exporter.get();
    }

    public void setExporter(HttpExporter exporter) {
        if (exporter == null) {
            this.exporter.set(this.fallbackExporter);
        } else {
            this.exporter.set(exporter);
        }
    }
}

