/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.proxy;

import org.eclipse.scada.hd.server.common.HistoricalItem;
import org.eclipse.scada.hd.server.proxy.ProxyHistoricalItem;
import org.eclipse.scada.utils.osgi.FilterUtil;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ProxyValueSource {
    private final SingleServiceTracker<HistoricalItem> tracker;
    private final SingleServiceListener<HistoricalItem> listener;
    private ServiceEntry service;
    private final ProxyHistoricalItem item;
    private final int priority;

    public ProxyValueSource(BundleContext context, String id, ProxyHistoricalItem item, int priority) throws InvalidSyntaxException {
        this.item = item;
        this.priority = priority;
        this.listener = new SingleServiceListener<HistoricalItem>(){

            public void serviceChange(ServiceReference<HistoricalItem> reference, HistoricalItem service) {
                ProxyValueSource.this.setService(service);
            }
        };
        this.tracker = new SingleServiceTracker(context, FilterUtil.createClassAndPidFilter((String)HistoricalItem.class.getName(), (String)id), this.listener);
        this.tracker.open();
    }

    protected void setService(HistoricalItem service) {
        if (this.service != null) {
            this.item.removeSource(this.service);
        }
        this.service = new ServiceEntry(service, this.priority);
        if (this.service != null) {
            this.item.addSource(this.service);
        }
    }

    public void dispose() {
        this.tracker.close();
        if (this.service != null) {
            this.item.removeSource(this.service);
        }
    }

    public static class ServiceEntry {
        private final HistoricalItem item;
        private final int priority;

        public ServiceEntry(HistoricalItem item, int priority) {
            this.item = item;
            this.priority = priority;
        }

        public HistoricalItem getItem() {
            return this.item;
        }

        public int getPriority() {
            return this.priority;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceEntry other = (ServiceEntry)obj;
            return !(this.item == null ? other.item != null : !this.item.equals(other.item));
        }
    }
}

