/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.ui.connection.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.scada.hd.ui.connection.data.Item;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemTransfer
extends ByteArrayTransfer {
    private static ItemTransfer instance = new ItemTransfer();
    private static final String TYPE_NAME = "eclipse-scada-hd-item-transfer-format";
    private static final int TYPE_ID = ItemTransfer.registerType((String)"eclipse-scada-hd-item-transfer-format");
    private static final Logger logger = LoggerFactory.getLogger(ItemTransfer.class);

    static {
        logger.info("Registered type '{}' with id '{}'", (Object)TYPE_NAME, (Object)TYPE_ID);
    }

    public static ItemTransfer getInstance() {
        return instance;
    }

    private ItemTransfer() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Item[] fromByteArray(byte[] bytes) {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int n = in.readInt();
            Item[] items = new Item[n];
            int i = 0;
            while (true) {
                if (i >= n) {
                    return items;
                }
                Item item = this.readItem(null, in);
                if (item == null) {
                    return null;
                }
                items[i] = item;
                ++i;
            }
        }
        catch (IOException e) {
            logger.warn("Failed to deseriablize", (Throwable)e);
            return null;
        }
    }

    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        byte[] bytes = this.toByteArray((Item[])object);
        if (bytes != null) {
            super.javaToNative((Object)bytes, transferData);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        return this.fromByteArray(bytes);
    }

    private Item readItem(Item parent, DataInputStream dataIn) throws IOException {
        Item item = new Item();
        item.setConnectionString(dataIn.readUTF());
        item.setId(dataIn.readUTF());
        return item;
    }

    protected byte[] toByteArray(Item[] items) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        byte[] bytes = null;
        try {
            out.writeInt(items.length);
            int i = 0;
            while (i < items.length) {
                this.writeItem(items[i], out);
                ++i;
            }
            out.close();
            bytes = byteOut.toByteArray();
        }
        catch (IOException e) {
            logger.warn("Failed to encode", (Throwable)e);
        }
        return bytes;
    }

    private void writeItem(Item item, DataOutputStream dataOut) throws IOException {
        dataOut.writeUTF(item.getConnectionString());
        dataOut.writeUTF(item.getId());
    }
}

