/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hds;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Quantizer {
    private static final Logger logger = LoggerFactory.getLogger(Quantizer.class);
    private final long millisTime;
    private final int count;
    private final long time;
    private final TimeUnit unit;

    public Quantizer(long time, TimeUnit unit) {
        this(time, unit, Integer.MAX_VALUE);
    }

    public Quantizer(long time, TimeUnit unit, int count) {
        this.millisTime = TimeUnit.MILLISECONDS.convert(time, unit);
        this.time = time;
        this.unit = unit;
        this.count = count;
    }

    public Date getEndOfPeriod(Date now) {
        if (now == null) {
            return new Date(System.currentTimeMillis() - this.millisTime * (long)this.count);
        }
        return new Date(now.getTime() - this.millisTime * (long)this.count);
    }

    protected Date getValidStart(Date timestamp, Date now) {
        Date end;
        Date start = this.getStart(timestamp);
        if (start.before(end = this.getEndOfPeriod(now))) {
            return null;
        }
        return start;
    }

    public Date getValidStart(Date timestamp) {
        return this.getValidStart(timestamp, new Date());
    }

    public Date getStart(Date timestamp) {
        if (timestamp == null) {
            return null;
        }
        long time = timestamp.getTime();
        long tix = time / this.millisTime * this.millisTime;
        logger.trace("Timestamp {} -> {}", (Object)time, (Object)tix);
        return new Date(tix);
    }

    public Date getNext(Date start) {
        if (start == null) {
            return null;
        }
        return new Date(start.getTime() + this.millisTime);
    }

    public Date getPrevious(Date start) {
        if (start == null) {
            return null;
        }
        return new Date(start.getTime() - this.millisTime);
    }

    public Date getEnd(Date timestamp) {
        return this.getNext(this.getStart(timestamp));
    }

    public String toString() {
        return String.format("[%s|%s|%s]", new Object[]{this.time, this.unit, this.count});
    }
}

