/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.net.base;

import org.eclipse.scada.net.base.handlers.PingHandler;
import org.eclipse.scada.net.base.handlers.PongHandler;
import org.eclipse.scada.net.mina.Messenger;
import org.eclipse.scada.net.utils.MessageCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingService {
    private static final Logger logger = LoggerFactory.getLogger(PingService.class);
    private final Messenger messenger;
    private volatile boolean started;

    public PingService(Messenger messenger) {
        this.messenger = messenger;
        this.messenger.setHandler(16, new PingHandler(this.messenger));
        this.messenger.setHandler(17, new PongHandler());
    }

    public void sendPing() {
        if (this.started) {
            logger.debug("Sending ping");
            this.messenger.sendMessage(MessageCreator.createPing());
        } else {
            logger.info("Skipping ping. Not started!");
        }
    }

    public void start() {
        logger.info("Starting ping service");
        this.started = true;
    }

    public void stop() {
        logger.info("Stopping ping service");
        this.started = false;
    }
}

