/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.modbus.codec;

import java.nio.ByteOrder;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.eclipse.scada.protocol.common.Checksum;
import org.eclipse.scada.protocol.common.io.TimedEndDecoder;
import org.eclipse.scada.protocol.modbus.io.ChecksumProtocolException;
import org.eclipse.scada.protocol.modbus.io.ModbusProtocolError;
import org.eclipse.scada.protocol.modbus.message.Pdu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusRtuDecoder
extends TimedEndDecoder {
    private static final Logger logger = LoggerFactory.getLogger(ModbusRtuDecoder.class);
    private static final String SESSION_KEY_CURRENT_FRAME = String.valueOf(ModbusRtuDecoder.class.getName()) + ".currentFrame";
    private static final int MAX_SIZE = 256;

    public ModbusRtuDecoder(ScheduledExecutorService scheduler, long interFrameDelay, TimeUnit timeUnit) {
        super(scheduler, interFrameDelay, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(IoSession session, ProtocolDecoderOutput out) throws Exception {
        IoFilter.NextFilter nextFilter;
        IoBuffer currentFrame;
        logger.trace("timeout ()");
        ModbusRtuDecoder modbusRtuDecoder = this;
        synchronized (modbusRtuDecoder) {
            currentFrame = (IoBuffer)session.removeAttribute((Object)SESSION_KEY_CURRENT_FRAME);
            if (currentFrame == null) {
                throw new ModbusProtocolError("no frame found");
            }
        }
        currentFrame.flip();
        this.decodeTimeoutFrame(session, currentFrame, out);
        ModbusRtuDecoder modbusRtuDecoder2 = this;
        synchronized (modbusRtuDecoder2) {
            nextFilter = this.nextFilter;
        }
        logger.trace("timeout () flush - nextFilter: {}", (Object)nextFilter);
        if (nextFilter != null) {
            out.flush(nextFilter, session);
        }
    }

    private void decodeTimeoutFrame(IoSession session, IoBuffer currentFrame, ProtocolDecoderOutput out) {
        logger.trace("timeout () frame = {}", (Object)currentFrame.getHexDump());
        if (currentFrame.limit() <= 3) {
            throw new ModbusProtocolError("frame must be at least 4 bytes long (address + data[] + crc low + crc high");
        }
        currentFrame.order(ByteOrder.LITTLE_ENDIAN);
        int receivedCrc = currentFrame.getUnsignedShort(currentFrame.limit() - 2);
        currentFrame.order(ByteOrder.BIG_ENDIAN);
        int actualCrc = Checksum.crc16((byte[])currentFrame.array(), (int)0, (int)(currentFrame.limit() - 2));
        if (receivedCrc != actualCrc) {
            logger.info("CRC error - received: {}, calculated: {} - data: {}", new Object[]{receivedCrc, actualCrc, currentFrame.getHexDump()});
            throw new ChecksumProtocolException(String.format("CRC error. received: %04x, but actually was: %04x", receivedCrc, actualCrc));
        }
        currentFrame.position(0);
        byte unitIdentifier = currentFrame.get();
        IoBuffer pdu = IoBuffer.allocate((int)(currentFrame.limit() - 3));
        int i = 0;
        while (i < currentFrame.limit() - 3) {
            pdu.put(currentFrame.get());
            ++i;
        }
        pdu.flip();
        out.write((Object)new Pdu(0, unitIdentifier, pdu));
    }

    public synchronized void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        IoBuffer currentFrame = (IoBuffer)session.getAttribute((Object)SESSION_KEY_CURRENT_FRAME);
        if (currentFrame == null) {
            currentFrame = IoBuffer.allocate((int)256);
            session.setAttribute((Object)SESSION_KEY_CURRENT_FRAME, (Object)currentFrame);
        }
        logger.trace("decode () current frame = {} data = {}", (Object)currentFrame.toString(), (Object)currentFrame.getHexDump());
        logger.trace("decode () new     frame = {} data = {}", (Object)in.toString(), (Object)in.getHexDump());
        int expectedSize = currentFrame.position() + in.remaining();
        if (expectedSize > 257) {
            throw new ModbusProtocolError(String.format("received size (%s) exceeds max size (%s)", expectedSize, 256));
        }
        currentFrame.put(in);
        this.tick(session, out);
    }
}

