/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.authz.signature;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.eclipse.scada.sec.authz.signature.X509CA;
import org.eclipse.scada.sec.authz.signature.X509KeySelectorResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509KeySelector
extends KeySelector {
    private static final Logger logger = LoggerFactory.getLogger(X509KeySelector.class);
    private final X509CA[] cas;

    public X509KeySelector(X509CA ca) {
        this(Collections.singleton(ca));
    }

    public X509KeySelector(Collection<X509CA> cas) {
        this.cas = cas.toArray(new X509CA[cas.size()]);
    }

    public void reload() {
        logger.debug("Reloading");
        X509CA[] x509CAArray = this.cas;
        int n = this.cas.length;
        int n2 = 0;
        while (n2 < n) {
            X509CA ca = x509CAArray[n2];
            logger.debug("Reloading ca: {}", (Object)ca);
            try {
                ca.load();
            }
            catch (InterruptedException e) {
                logger.warn("Failed to reload", (Throwable)e);
                return;
            }
            catch (Exception e) {
                logger.warn("Failed to reload", (Throwable)e);
            }
            ++n2;
        }
    }

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        if (keyInfo == null) {
            throw new KeySelectorException("Null KeyInfo object!");
        }
        SignatureMethod sm = (SignatureMethod)method;
        List<XMLStructure> list = keyInfo.getContent();
        for (XMLStructure l : list) {
            XMLStructure xmlStructure = l;
            if (!(xmlStructure instanceof X509Data)) continue;
            for (Object o : ((X509Data)xmlStructure).getContent()) {
                KeySelectorResult result = null;
                if (o instanceof X509Certificate) {
                    result = this.findPublicKey((X509Certificate)o, sm);
                }
                if (result == null) continue;
                return result;
            }
        }
        throw new KeySelectorException("No KeyValue element found!");
    }

    private KeySelectorResult findPublicKey(X509Certificate cert, SignatureMethod sm) {
        block9: {
            PublicKey pk = cert.getPublicKey();
            if (pk != null && X509KeySelector.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) break block9;
            return null;
        }
        try {
            logger.trace("Checking certificate validity");
            cert.checkValidity();
            X509CA[] x509CAArray = this.cas;
            int n = this.cas.length;
            int n2 = 0;
            while (n2 < n) {
                X509CA ca = x509CAArray[n2];
                logger.trace("Checking CA: {}", (Object)ca);
                if (ca.isRevoked(cert)) {
                    logger.trace("Cert is revoked by CA");
                } else {
                    X509Certificate[] x509CertificateArray = ca.getCertificates();
                    int n3 = x509CertificateArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        X509Certificate caCert = x509CertificateArray[n4];
                        try {
                            logger.debug("Checking CA validity");
                            caCert.checkValidity();
                            logger.debug("Validate certificate");
                            cert.verify(caCert.getPublicKey());
                            return new X509KeySelectorResult(cert);
                        }
                        catch (Exception exception) {
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.trace("Failed to select key", (Throwable)e);
        }
        return null;
    }

    static boolean algEquals(String algURI, String algName) {
        if (algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return true;
        }
        if (algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
            return true;
        }
        logger.trace("Failed to check key - algUri: {}, algName: {}", (Object)algURI, (Object)algName);
        return false;
    }
}

