/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.equinox;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.UserInformationPrincipal;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.equinox.Activator;
import org.eclipse.scada.sec.equinox.JavaCallbackHandler;

public class LoginModule
implements javax.security.auth.spi.LoginModule {
    private javax.security.auth.callback.CallbackHandler callbackHandler;
    private boolean loggedIn;
    private Subject subject;
    private UserInformation userInformation;

    public void initialize(Subject subject, javax.security.auth.callback.CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        this.userInformation = null;
        AuthenticationImplementation auth = Activator.getInstance().getAuthentication();
        try {
            this.userInformation = (UserInformation)auth.authenticate((CallbackHandler)new JavaCallbackHandler(this.callbackHandler)).get();
        }
        catch (Exception e) {
            LoginException loginException = new LoginException();
            loginException.initCause(e);
            throw loginException;
        }
        this.loggedIn = this.userInformation != null;
        return this.loggedIn;
    }

    @Override
    public boolean commit() throws LoginException {
        this.subject.getPrincipals().add((Principal)new UserInformationPrincipal(this.userInformation));
        this.subject.getPublicCredentials().add(this.userInformation);
        return this.loggedIn;
    }

    @Override
    public boolean abort() throws LoginException {
        this.loggedIn = false;
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.loggedIn = false;
        return true;
    }
}

