/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.osgi.manager;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.sec.AuthorizationReply;
import org.eclipse.scada.sec.AuthorizationRequest;
import org.eclipse.scada.sec.AuthorizationResult;
import org.eclipse.scada.sec.AuthorizationService;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.eclipse.scada.sec.osgi.AuthorizationHelper;
import org.eclipse.scada.sec.osgi.AuthorizationManager;
import org.eclipse.scada.sec.osgi.AuthorizationTracker;
import org.eclipse.scada.sec.osgi.manager.ConfigurationEntry;
import org.eclipse.scada.sec.osgi.manager.MonitorImpl;
import org.eclipse.scada.sec.osgi.manager.ServiceTrackerCustomizerImplementation;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.str.Tables;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationManagerImpl
implements AuthorizationManager,
ConfigurationFactory,
AuthorizationTracker {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationManagerImpl.class);
    private ServiceTracker<AuthorizationService, AuthorizationService> tracker;
    private final Set<MonitorImpl> monitors = new LinkedHashSet<MonitorImpl>();
    private final HashMap<String, AuthorizationService> services = new HashMap();
    private ExecutorService executor;
    private List<ConfigurationEntry> configurationCache = Collections.emptyList();
    private final Map<String, ConfigurationEntry> configuration = new HashMap<String, ConfigurationEntry>();

    public void activate(BundleContext context) {
        this.executor = new ExportedExecutorService(AuthorizationManagerImpl.class.getName(), 1, 1, 1L, TimeUnit.MINUTES);
        this.tracker = new ServiceTracker(context, AuthorizationService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizerImplementation(this, context));
        this.tracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        ExecutorService exeService;
        AuthorizationManagerImpl authorizationManagerImpl = this;
        synchronized (authorizationManagerImpl) {
            this.tracker.close();
            this.tracker = null;
            this.invalidateAll();
            exeService = this.executor;
            this.executor = null;
        }
        exeService.shutdown();
    }

    public synchronized AuthorizationTracker.Monitor createMonitor(AuthorizationTracker.Listener listener, AuthorizationRequest request) {
        MonitorImpl monitor = new MonitorImpl(this, listener, request);
        this.monitors.add(monitor);
        this.revalidateMonitor(monitor);
        return monitor;
    }

    public synchronized void disposeMonitor(MonitorImpl monitor) {
        this.monitors.remove(monitor);
    }

    private void invalidateAll() {
        for (MonitorImpl monitor : this.monitors) {
            this.monitorSetResult(monitor, AuthorizationReply.create((AuthorizationResult)AuthorizationHelper.DEFAULT_RESULT, (AuthorizationContext)monitor.getContext()));
        }
    }

    private void monitorSetResult(final MonitorImpl monitor, final AuthorizationReply result) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                monitor.setResult(result);
            }
        });
    }

    synchronized void addService(AuthorizationService service, String[] serviceTypes) {
        logger.debug("Service added - {} / {}", (Object)service, (Object)serviceTypes);
        String[] stringArray = serviceTypes;
        int n = serviceTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String serviceType = stringArray[n2];
            this.services.put(serviceType, service);
            ++n2;
        }
        this.realizeAll();
    }

    private void realizeAll() {
        int realized = 0;
        for (ConfigurationEntry cfg : this.configuration.values()) {
            if (!cfg.realize()) continue;
            ++realized;
        }
        logger.info("Realized {} entries", (Object)realized);
        if (realized > 0) {
            this.revalidateAll();
        }
    }

    synchronized void removeService(AuthorizationService service) {
        logger.debug("Service removed - {}", (Object)service);
        boolean removedService = false;
        Iterator<Map.Entry<String, AuthorizationService>> i = this.services.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, AuthorizationService> entry = i.next();
            if (entry.getValue() != service) continue;
            i.remove();
            removedService = true;
        }
        boolean removed = false;
        if (removedService) {
            for (ConfigurationEntry cfg : this.configuration.values()) {
                if (!cfg.realizedBy(service)) continue;
                cfg.unrealize();
                removed = true;
            }
        }
        if (removed) {
            this.revalidateAll();
        }
    }

    public synchronized void revalidateAll() {
        for (MonitorImpl monitor : this.monitors) {
            this.revalidateMonitor(monitor);
        }
    }

    private void revalidateMonitor(final MonitorImpl monitor) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                AuthorizationManagerImpl.this.performRevalidate(monitor);
            }
        });
    }

    protected void performRevalidate(final MonitorImpl monitor) {
        this.authorize(monitor.getContext(), AuthorizationHelper.DEFAULT_RESULT).addListener((FutureListener)new FutureListener<AuthorizationReply>(){

            public void complete(Future<AuthorizationReply> future) {
                try {
                    AuthorizationManagerImpl.this.monitorSetResult(monitor, future.get());
                }
                catch (Exception e) {
                    logger.warn("Failed to check", (Throwable)e);
                    AuthorizationManagerImpl.this.monitorSetResult(monitor, AuthorizationReply.create((AuthorizationResult)AuthorizationResult.createReject((Throwable)e), (AuthorizationContext)monitor.getContext()));
                }
            }
        });
    }

    protected synchronized Iterable<ConfigurationEntry> getCurrentRules() {
        return this.configurationCache;
    }

    public NotifyFuture<AuthorizationReply> authorize(AuthorizationContext context, AuthorizationResult defaultResult) {
        return AuthorizationHelper.authorize(this.getCurrentRules(), (AuthorizationContext)context, (AuthorizationResult)defaultResult);
    }

    public synchronized void update(UserInformation userInformation, String configurationId, Map<String, String> parameters) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        String serviceType = cfg.getStringChecked("serviceType", "The 'serviceType' must be set");
        int priority = cfg.getIntegerChecked("priority", "'priority' must be set");
        ConfigurationEntry newCfg = new ConfigurationEntry(this, configurationId, serviceType, priority, cfg.getPrefixed("properties."));
        newCfg.setPreFilter(parameters);
        ConfigurationEntry oldCfg = this.configuration.put(configurationId, newCfg);
        if (oldCfg != null) {
            oldCfg.dispose();
        }
        newCfg.realize();
        this.updateCache();
        this.revalidateAll();
    }

    private void updateCache() {
        this.configurationCache = new ArrayList<ConfigurationEntry>(this.configuration.values());
        Collections.sort(this.configurationCache);
    }

    public synchronized void delete(UserInformation userInformation, String configurationId) throws Exception {
        ConfigurationEntry oldCfg = this.configuration.remove(configurationId);
        if (oldCfg == null) {
            return;
        }
        oldCfg.dispose();
        this.updateCache();
        this.revalidateAll();
    }

    public synchronized AuthorizationService findService(String serviceType) {
        return this.services.get(serviceType);
    }

    public void list() {
        LinkedList data = new LinkedList();
        for (ConfigurationEntry cfg : this.configurationCache) {
            LinkedList<String> row = new LinkedList<String>();
            row.add(cfg.getId());
            row.add("" + cfg.getPriority());
            row.add(cfg.getServiceType());
            row.add(cfg.isRealized() ? "X" : "");
            row.add(cfg.getTypeFilter() == null ? "" : cfg.getTypeFilter().toString());
            row.add(cfg.getIdFilter() == null ? "" : cfg.getIdFilter().toString());
            row.add(cfg.getActionFilter() == null ? "" : cfg.getActionFilter().toString());
            row.add(ExceptionHelper.getMessage((Throwable)cfg.getError()));
            data.add(row);
        }
        Tables.showTable((PrintStream)System.out, Arrays.asList("ID", "Priority", "ServiceType", "Realized", "TypeFilter", "IdFilter", "ActionFilter", "Error"), data, (int)2);
    }
}

