/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.provider.plain.property;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.scada.sec.authn.AbstractPlainAuthenticationService;

public class PropertyAuthenticationService
extends AbstractPlainAuthenticationService {
    public static final String PROP = "org.eclipse.scada.sec.provider.plain.property.data";
    protected Map<String, AbstractPlainAuthenticationService.UserEntry> userInformation = new HashMap<String, AbstractPlainAuthenticationService.UserEntry>();

    public PropertyAuthenticationService() {
        this.userInformation.putAll(PropertyAuthenticationService.split(System.getProperty(PROP, "")));
    }

    public static Map<String, AbstractPlainAuthenticationService.UserEntry> split(String data) {
        StringTokenizer tok = new StringTokenizer(data, "|");
        HashMap<String, AbstractPlainAuthenticationService.UserEntry> result = new HashMap<String, AbstractPlainAuthenticationService.UserEntry>();
        while (tok.hasMoreElements()) {
            String password;
            String name;
            String[] toks = tok.nextToken().split(":");
            if (toks.length == 3) {
                name = toks[0];
                password = toks[1];
                String[] roles = toks[2].split(",");
                AbstractPlainAuthenticationService.UserEntry entry = new AbstractPlainAuthenticationService.UserEntry(password, Arrays.asList(roles));
                result.put(name, entry);
                continue;
            }
            if (toks.length != 2) continue;
            name = toks[0];
            password = toks[1];
            AbstractPlainAuthenticationService.UserEntry entry = new AbstractPlainAuthenticationService.UserEntry(password, Collections.emptyList());
            result.put(name, entry);
        }
        return result;
    }

    protected AbstractPlainAuthenticationService.UserEntry getUserEntry(String name) {
        return this.userInformation.get(name);
    }
}

