/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.utils.password;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.sec.utils.password.PasswordEncoding;
import org.eclipse.scada.sec.utils.password.PasswordValidator;

public class PlainValidator
implements PasswordValidator {
    private static final List<PasswordEncoding> ENCODINGS = Arrays.asList(PasswordEncoding.SHA1, PasswordEncoding.MD5, PasswordEncoding.PLAIN);
    private final boolean ignoreCase;

    public PlainValidator(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public List<PasswordEncoding> getSupportedInputEncodings() {
        return ENCODINGS;
    }

    @Override
    public boolean validatePassword(Map<PasswordEncoding, String> passwords, String storedPassword) throws Exception {
        for (PasswordEncoding encoding : ENCODINGS) {
            String providedPassword = passwords.get((Object)encoding);
            if (providedPassword == null) continue;
            String storedEncoded = encoding.encodeToHexString(storedPassword);
            return this.comparePassword(providedPassword, storedEncoded);
        }
        return false;
    }

    private boolean comparePassword(String providedPassword, String storedPassword) {
        if (this.ignoreCase) {
            return providedPassword.equalsIgnoreCase(storedPassword);
        }
        return providedPassword.equals(storedPassword);
    }
}

