/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.selector;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.scada.ui.chart.model.Chart;
import org.eclipse.scada.ui.chart.model.ChartPackage;
import org.eclipse.scada.ui.chart.model.DataSeries;
import org.eclipse.scada.ui.chart.selector.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ChartConfigurationInputSelector {
    private final CheckboxTableViewer viewer;
    private final IObservableList inputs;
    private final IViewerObservableSet checked;

    public ChartConfigurationInputSelector(Composite parent, Chart chart) {
        this(parent, chart, false);
    }

    public ChartConfigurationInputSelector(Composite parent, Chart chart, boolean showHeader) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)65536);
        this.viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ChartConfigurationInputSelector.this.handleDispose();
            }
        });
        this.inputs = EMFObservables.observeList((EObject)chart, (EStructuralFeature)ChartPackage.Literals.CHART__INPUTS);
        if (showHeader) {
            TableLayout layout = new TableLayout();
            TableViewerColumn col = new TableViewerColumn((TableViewer)this.viewer, 0);
            col.getColumn().setText(Messages.ChartConfigurationInputSelector_Channels_Label);
            this.viewer.getTable().setHeaderVisible(true);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
            this.viewer.getTable().setLayout((Layout)layout);
        }
        ViewerSupport.bind((StructuredViewer)this.viewer, (IObservableList)this.inputs, (IValueProperty)EMFProperties.value((EStructuralFeature)ChartPackage.Literals.DATA_SERIES__LABEL));
        IObservableSet elements = ((ObservableListContentProvider)this.viewer.getContentProvider()).getKnownElements();
        IObservableMap[] visibile = Properties.observeEach((IObservableSet)elements, (IValueProperty[])new IValueProperty[]{EMFProperties.value((EStructuralFeature)ChartPackage.Literals.DATA_SERIES__VISIBLE)});
        this.checked = ViewersObservables.observeCheckedElements((CheckboxTableViewer)this.viewer, null);
        for (DataSeries series : chart.getInputs()) {
            if (!series.isVisible()) continue;
            this.checked.add((Object)series);
        }
        this.checked.addSetChangeListener(new ISetChangeListener(){

            public void handleSetChange(SetChangeEvent event) {
                for (Object o : event.diff.getAdditions()) {
                    ((DataSeries)o).setVisible(true);
                }
                for (Object o : event.diff.getRemovals()) {
                    ((DataSeries)o).setVisible(false);
                }
            }
        });
        visibile[0].addMapChangeListener(new IMapChangeListener(){

            public void handleMapChange(MapChangeEvent event) {
                for (Object o : event.diff.getChangedKeys()) {
                    if (((Boolean)event.diff.getNewValue(o)).booleanValue()) {
                        ChartConfigurationInputSelector.this.checked.add(o);
                        continue;
                    }
                    ChartConfigurationInputSelector.this.checked.remove(o);
                }
            }
        });
    }

    protected void handleDispose() {
        this.viewer.getLabelProvider().dispose();
        this.viewer.getContentProvider().dispose();
        this.checked.dispose();
        this.inputs.dispose();
    }

    public void dispose() {
        this.viewer.getControl().dispose();
    }
}

