/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.ui.chart.model.ChartPackage;
import org.eclipse.scada.ui.chart.model.DataSeries;
import org.eclipse.scada.ui.chart.model.XAxis;
import org.eclipse.scada.ui.chart.model.YAxis;
import org.eclipse.scada.ui.chart.viewer.AbstractObserver;
import org.eclipse.scada.ui.chart.viewer.AxisLocator;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.InputViewer;
import org.eclipse.scada.ui.chart.viewer.XAxisViewer;
import org.eclipse.scada.ui.chart.viewer.YAxisViewer;

public abstract class AbstractInputViewer
extends AbstractObserver
implements InputViewer {
    public static final String PROP_X_AXIS = "XAxis";
    public static final String PROP_Y_AXIS = "YAxis";
    protected final ChartViewer viewer;
    protected XAxisViewer xAxis;
    protected YAxisViewer yAxis;
    private final AxisLocator<XAxis, XAxisViewer> xLocator;
    private final AxisLocator<YAxis, YAxisViewer> yLocator;
    protected XAxis x;
    protected YAxis y;
    protected final ResourceManager resourceManager;
    private boolean visibile;
    private final DataSeries element;
    private final DataBindingContext dbc;

    public AbstractInputViewer(DataBindingContext dbc, DataSeries element, ChartViewer viewer, ResourceManager resourceManager, AxisLocator<XAxis, XAxisViewer> xLocator, AxisLocator<YAxis, YAxisViewer> yLocator) {
        this.element = element;
        this.viewer = viewer;
        this.dbc = dbc;
        this.resourceManager = new LocalResourceManager(resourceManager);
        this.xLocator = xLocator;
        this.yLocator = yLocator;
        this.addBinding(dbc.bindValue(PojoObservables.observeValue((Object)this, (String)"x"), EMFObservables.observeValue((EObject)element, (EStructuralFeature)ChartPackage.Literals.DATA_SERIES__X)));
        this.addBinding(dbc.bindValue(PojoObservables.observeValue((Object)this, (String)"y"), EMFObservables.observeValue((EObject)element, (EStructuralFeature)ChartPackage.Literals.DATA_SERIES__Y)));
    }

    protected void setInputObserable(IObservableValue inputObservable) {
        this.addBinding(this.dbc.bindValue(PojoObservables.observeDetailValue((IObservableValue)inputObservable, (String)"visible", Boolean.class), EMFObservables.observeValue((EObject)this.element, (EStructuralFeature)ChartPackage.Literals.DATA_SERIES__VISIBLE)));
        this.addBinding(this.dbc.bindValue(PojoObservables.observeDetailValue((IObservableValue)inputObservable, (String)"label", String.class), EMFObservables.observeValue((EObject)this.element, (EStructuralFeature)ChartPackage.Literals.DATA_SERIES__LABEL)));
    }

    protected abstract void checkCreateInput();

    protected abstract void disposeInput();

    public void setVisibile(boolean visibile) {
        this.visibile = visibile;
    }

    public boolean isVisibile() {
        return this.visibile;
    }

    public void setX(XAxis x) {
        this.disposeInput();
        this.x = x;
        this.setXAxis(this.xLocator.findAxis(x));
        this.checkCreateInput();
    }

    public XAxis getX() {
        return this.x;
    }

    public void setY(YAxis y) {
        this.disposeInput();
        this.y = y;
        this.setYAxis(this.yLocator.findAxis(y));
        this.checkCreateInput();
    }

    public YAxis getY() {
        return this.y;
    }

    public YAxisViewer getYAxis() {
        return this.yAxis;
    }

    public void setYAxis(YAxisViewer yAxis) {
        this.yAxis = yAxis;
        this.firePropertyChange(PROP_Y_AXIS, (Object)this.yAxis, (Object)this.yAxis);
    }

    public XAxisViewer getXAxis() {
        return this.xAxis;
    }

    public void setXAxis(XAxisViewer xAxis) {
        this.xAxis = xAxis;
        this.firePropertyChange(PROP_X_AXIS, (Object)this.xAxis, (Object)this.xAxis);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeInput();
        this.resourceManager.dispose();
    }
}

