/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.databinding;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scada.ui.databinding.AdapterHelper;

public class SelectionHelper {
    public static <T> Iterator<T> iterator(ISelection selection, Class<T> clazz) {
        return SelectionHelper.list(selection, clazz).iterator();
    }

    public static List<?> list(ISelection selection) {
        LinkedList result = new LinkedList();
        if (selection instanceof IStructuredSelection) {
            for (Object o : (IStructuredSelection)selection) {
                if (o == null) continue;
                result.add(o);
            }
        }
        return result;
    }

    public static <T> List<T> list(ISelection selection, Class<T> clazz) {
        LinkedList<T> result = new LinkedList<T>();
        if (selection instanceof IStructuredSelection) {
            for (Object o : (IStructuredSelection)selection) {
                if (o == null) continue;
                if (clazz.isAssignableFrom(o.getClass())) {
                    result.add(clazz.cast(o));
                    continue;
                }
                T ro = AdapterHelper.adapt(o, clazz);
                if (ro == null) continue;
                result.add(ro);
            }
        }
        return result;
    }

    public static <T> Iterable<T> iterable(final ISelection selection, final Class<T> clazz) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return SelectionHelper.iterator(selection, clazz);
            }
        };
    }

    public static <T> T first(ISelection selection, Class<T> clazz) {
        Iterator<T> i = SelectionHelper.iterator(selection, clazz);
        if (i.hasNext()) {
            return i.next();
        }
        return null;
    }
}

