/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.databinding.observable;

import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public class ObservableMapContentProvider
implements IStructuredContentProvider {
    private IObservableMap input;
    private IMapChangeListener mapListener;
    private StructuredViewer viewer;

    public void dispose() {
        this.detach();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.detach();
        this.viewer = (StructuredViewer)viewer;
        if (newInput instanceof IObservableMap) {
            this.setInput((IObservableMap)newInput);
        }
    }

    private void detach() {
        if (this.mapListener != null && this.input != null) {
            this.input.removeMapChangeListener(this.mapListener);
            this.mapListener = null;
            this.input = null;
        }
    }

    private void setInput(IObservableMap input) {
        this.input = input;
        this.mapListener = new IMapChangeListener(){

            public void handleMapChange(MapChangeEvent event) {
                ObservableMapContentProvider.this.mapChange(event.diff);
            }
        };
        input.addMapChangeListener(this.mapListener);
    }

    protected void mapChange(MapDiff diff) {
        this.viewer.refresh();
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != this.input) {
            return null;
        }
        return this.input.entrySet().toArray();
    }
}

